function histogram_ratio_new, x, y, xout, yout, log=log, tan=tan, plot=plot, $
                          mode=mode, bin_range=bin_range, title=title, $
                              ratio_plot=ratio_plot
;+
;   Histogram the ratio y/x and return the histogram distribution
;   /log means to histogram in log-space
;-
status=0
ndata=n_elements(x)

if not keyword_set(title) then title='Histogram Plot'

if keyword_set(log) then begin
    ratio=y/x
    r=where(ratio gt 0,nr)
    if nr eq 0 then begin
        print, 'No non-zero ratios available.'
        return,-1
    endif
    ratio=alog(ratio(r))
    binsize=0.0025
    hist_min=-10
    hist_max=2.0
    xtitle='Ln Ratio'
    inv='exp(xout)'
endif else if keyword_set(tan) then begin
    ratio=atan(y,x)
    binsize=0.01
    hist_min=0.0
    hist_max=0.5*!pi
    xtitle='Atan(Ratio)'
    inv='tan(xout)'
endif else begin
    ratio=y/x
    binsize=0.001
    hist_min=0.0
    hist_max=10.0
    xtitle='Ratio'
    inv='xout'
endelse

histogram_rdh,ratio,xout,yout,binsize=binsize,$
  min=hist_min,max=hist_max,res=residue

max=max(yout,imode)
mode=xout(imode)
rsave=where(ratio le 10)
rave=total(yout(rsave)*xout(rsave),/double)/$
  total(yout(rsave))
rave=total(y)/total(x)

maxr=xout(imode)
disp=(total((ratio(rsave)-maxr)^2)/n_elements(rsave))^0.5

mult=(disp/100.0)/binsize
if mult*max gt 50 then binsize=disp/100.0 else begin
    binsize=binsize*50/max
    if (disp/100.0)/binsize lt 0.05 then binsize=2*binsize
endelse
                    
if(binsize gt 1) then binsize=1.0

histogram_rdh,ratio,xout,yout,binsize=binsize,$
  min=hist_min,max=hist_max,res=residue
;
;   Plot
;
if keyword_set(plot) then begin

    if keyword_set(ratio_plot) then begin
        ymax=max(yout, imax)
;        r=where(yout gt 0.01*ymax, nr)
;        xmin=xout(0)
;        xmax=xout(r(nr-1))
        xmin=0
        xmax=!pi/2.0
        
        plot, xout, yout, $
          title=title, charsize=1.5, $
          xtitle=xtitle, ytitle='Freq.', xrange=[xmin, xmax], psym=10

        status_xout=execute('xout='+inv)
        if status_xout eq 1 then $
          xtitle='Ratio [Hist '+xtitle+']'
        rd=where(xout lt 0,nrd)
        if nrd gt 0 then begin
;            ry=where(yout(rd) ne 0,nry)
;            if nry gt 0 then $
;              message, 'WARNING: Non-Monotonic xout, yout ne 0'
            rd=where(xout ge 0,nrd)
            xout=xout(rd)
            yout=yout(rd)
        endif
    endif

    ymax=max(yout, imax)
    ;r=where(yout gt 0.01*ymax, nr)
    ;xmin=xout(0)
    ;xmax=xout(r(nr-1))
    xmin=0
    xmax=!pi/2.0

    plot, xout, yout, $
      title=title, charsize=1.5, $
      xtitle=xtitle, ytitle='Freq.', xrange=[xmin, xmax], psym=10
endif
;
;   Calculate Mode
;
xc=xout(2:*)
yc=yout(2:*)

max=max(yc,ix)
mode=xc(ix)

r=where(yc gt max*0.5, nr)
if nr gt 0 then bin_range=xc([r(0), r(nr-1)]) else bin_range=[0,!pi/2]
;
;   Plot
;
;if keyword_set(plot) then begin
;    oplot, mode*[1,1], !y.crange, linestyle=1
;    oplot, bin_range(0)*[1,1], !y.crange, linestyle=5
;    oplot, bin_range(1)*[1,1], !y.crange, linestyle=5
;endif
if keyword_set(log) then begin
    mode=exp(mode)
    bin_range=exp(bin_range)
endif else if keyword_set(tan) then begin
    mode=tan(mode)
    bin_range=tan(bin_range)
endif

return, 0
end

