pro hyd_access_cache, timetags_io, ident, var_out, $
                      get_timetags=get_timetags, $
                      time_start=time_start, time_end=time_end, $
                      flush_cache=flush_cache, nocache=nocache, $
                      _extra=e
;+
;
;   pro hyd_access_cache
;
;   Call hyd_access and cache the result.
;
;   Keywords:
;
;      time_start=time_start       (in DOY96)
;      time_end=time_end           (in DOY96)
;
;      get_timetags=get_timetags   (passed to hyd_access, but used to
;                                   determine to cache timetags)
;
;      /nocache                    (circumvent caching)
;      /flush_cache                (reset caching for all!!!)
;
;-
timetags_label='timetags_'+ident
var_label=ident

if keyword_set(nocache) then begin
    hyd_access, timetags_io, ident, var_out, get_timetags=get_timetags, $
                      _extra=e
    return
endif

tfuzz=0.0005d0/86400.d0
if not keyword_set(flush_cache) then begin
    cache_status1=cache_variable(label=timetags_label, data=timetags, /read)
    cache_status2=cache_variable(label=var_label, data=var, /read)
endif else begin
    cache_status1=cache_variable(label=timetags_label, data=timetags, /reset)
    cache_status1=1
    cache_status2=1
endelse
if keyword_set(get_timetags) then begin
    if not keyword_set(time_start) or not keyword_set(time_end) then begin
        message, 'Keywords time_start, time_end required.', /cont
        x=temporary(timetags_io)
        y=temporary(var_out)
        return
    endif
    get_timetags_all=[time_start,time_end]

    if cache_status1 eq 0 and cache_status2 eq 0 then begin
        n=n_elements(timetags)-1
        timetags_start=timetags[0].bin_start-tfuzz
        timetags_end=timetags[n].bin_start+timetags[n].bin_width+tfuzz
        if ((time_start lt timetags_start) or $
            (time_end gt timetags_end)) then begin
            message, 'Cached data does not cover requested interval.'+$
              ' Flushing caches.', /cont
            cache_status1=cache_variable(label=timetags_label, $
                                         data=timetags, /reset)
            cache_status1=1
            cache_status2=1
        endif
    endif
endif else begin
    get_timetags_all=0
endelse

if cache_status1 ne 0 or cache_status2 ne 0 then begin
    message, 'Retrieving '+ident+' from hyd_access...', /cont
    hyd_access, timetags, ident, var, get_timetags=get_timetags_all, $
                      _extra=e

    message, 'Caching '+ident, /cont
    cache_status1=cache_variable(label=timetags_label, data=timetags, /save)
    cache_status2=cache_variable(label=var_label, data=var, /save)
    if cache_status1 eq -1 or cache_status2 eq -1 then begin
        message, 'Error caching '+ident
;        message, 'Error caching '+ident, /cont
;        x=temporary(timetags_io)
;        y=temporary(var_out)
;        return
    endif
endif else begin
    message, 'Using cached data for '+ident, /cont
endelse

if keyword_set(get_timetags) then begin
    r=where(timetags.bin_start ge get_timetags[0]-tfuzz and $
           timetags.bin_start lt get_timetags[1]+tfuzz)
    if r[0] eq -1 then begin
        message, 'No matching timetags found for '+ident, /cont
        x=temporary(var_out)
        y=temporary(timetags_io)
        return
    endif
    timetags_io=timetags[r]
    var_out=var[r]
endif else begin
    n=n_elements(timetags_io)-1
    timetags_start=timetags_io[0].bin_start-tfuzz
    timetags_end=timetags_io[n].bin_start+timetags_io[n].bin_width_tfuzz
    r=where(timetags.bin_start ge timetags_start and $
            timetags.bin_start lt timetags_end)
    if r[0] eq -1 then begin
        message, 'No matching timetags found for '+ident, /cont
        dims=size(var, /dimensions)
        dims[0]=n_elements(timetags_io)
        var_out=make_array(type=size(var, /type), dim=dims, val=-1e31)
        return
    endif
    var_out=var[r]
endelse
end











