function hyd_check_kp_survey, date
;+
;   Compares the CDHF kp "Epoch", "ELE_DENSITY" to the 
;                Survey  "TIME",  "KP_DENSITY_ELE"
;
;   Input:  8-digit date.
;
;   Return value of 0 indicated consistent files.
;
;   -1: No Survey file found
;   -2: More than 1 survey file found
;   -11: No CDHF_kp file found
;   -12: More than 1 CDHF_kp file found
;
;   1: CDHF_kp time doesn't match a survey time
;   2: Electron Densities don't match for a corresponding time
;
;-
status=0
date=strtrim(date,2)
;
;  Find files
;
survey_file=hydra_findfile(date, /survey,count=nsf)
if nsf ne 1 then $
  if nsf eq 0 then return, -1 else return, -2
ids=cdf_open(survey_file)
cdf_varget, ids, 'TIME', survey_time, rec_count=6272
cdf_varget, ids, 'KP_DENSITY_ELE', survey_density, rec_count=6272
cdf_close, ids

kp_file=hydra_findfile(date, /CDHF,kf)
if nkf ne 1 then $
  if nkf eq 0 then return, -11 else return, -12
idk=cdf_open(kp_file)
cdf_varget, idk, 'Epoch', epoch_time, rec_count=2000
kp_time=(epoch_time mod 86400000.d0)/1000.d0
cdf_varget, idk, 'ELE_DENSITY', kp_density, rec_count=2000
cdf_close, idk

r=where(kp_time ge 0,nr)
kp_time=kp_time(r)
kp_density=kp_density(r)
for i=0,nr-1 do begin
    r=where(abs(survey_time-kp_time(i)) lt 1.0,nr)
    if nr ne 0 then begin
        diff=abs((kp_density(i)-survey_density(r(0)))/kp_density(i))
        if diff gt 1.e-6 then begin
            print, kp_time(i), kp_density(i), survey_density(r(0))
            status=2
        endif
    endif else begin
        print, 'No matching time found: ', kp_time(i)
        status=1
    endelse
endfor

return, status
end
