function hyd_mkdir, dir, quiet=quiet
;+
;
;  Create a directory, including directories above it, on unix and MSDOS.
;
;-
if !version.os_family eq 'unix' then begin
    spawn, '(umask 2;/usr/bin/mkdir -p '+dir+' 2> /dev/null)', /sh, result
endif else begin
    bs='\'                      ; \\'
    if strpos(dir,bs) ne -1 then begin
        sep=bs
    endif else begin
        sep='/'
    endelse
    dirs=str_sep(dir,sep)
    sep=bs
    d=dirs(0)
    if strlen(d) ne 2 or rstrpos(d,':') ne 1 then begin
        print, 'Checking for '+d
        f=findfile(d,count=nf)
        if nf eq 0 then spawn, 'mkdir '+d
    endif
    for i=1,n_elements(dirs)-1 do begin
        d=d+sep+dirs(i)
        print, 'Checking for '+d
        f=findfile(d,count=nf)
        if nf eq 0 then spawn, 'mkdir '+d
    endfor
endelse
return, 0
end
