pro diagonal_binner, x_data, y_data, intercept_hypo, slope_hypo, npts_group


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Purpose: bin data along hypothetical line to give equal numbers
;         per bin with attendant uncertainties.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;     Technique:   x',y' = M(x, y-intercept)
;
;     Where M is the matrix that undoes the slope of the hypothesis
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
restore, filename='/opt/hydra/gains_tmp/data/trial3420/3420_3_5.idlsav',/verbose
; RESTORE: Portable (XDR) SAVE/RESTORE file.
; RESTORE: Save file written by rdh@sophie, Tue Dec  4 13:42:40 2001.
; RESTORE: IDL version 5.1 (sunos, sparc).
; RESTORE: Restored variable: C2.
; RESTORE: Restored variable: C1.
; RESTORE: Restored variable: SIGMA_C2.
; RESTORE: Restored variable: SIGMA_C1.
; RESTORE: Restored variable: PEAK.
; RESTORE: Restored variable: REDCHISQ.
x_data=c1
y_data=c2
sigma_x=sigma_c1
sigma_y=sigma_c2
x=c1
y=c2
sigx=sigma_c1
sigy=sigma_c2


fitscreen, x, y, sigx, sigy, slope_out_best, error_slope_best, $
               chisq_out_best,$
               slope_x_sort, error_x_sort, chisq_x_sort,$
               slope_y_sort, error_y_sort, chisq_y_sort,$
               slope_fit_linear_to_raw, error_raw, chisq_raw, $
               xaverage_save, xdisp_save, $
               yaverage_save, ydisp_save,plot=plot, $
               kappa_data_out= kappa_data, $
               x_out=x_out, y_out=y_out, $
               sigx_out= sigx_out, $
               sigy_out= sigy_jds_out, $
               ks_c99= ks_c99, $
               ks_c68= ks_c68, $
               s2=s2_out

intercept_hypo=0
slope_hypo=slope_out_best
print, slope_hypo
stop


plot, x_data, y_dat
