pro b_data_in
;;;;;
;;
;; Purpose to rough up B field data with zeros problems in weak and strong fields put it through
;; the averager, get the guard bands back
;;
;;;;;;
hydra_setcolors,cs
offset_x= -0.5
offset_y= 1.34
offset_z= 0.75  ; nt
true_x= 0.5
true_y=0.3
true_z=(1-true_x^2-true_y^2)^0.5
;timein spin period units

time = findgen(20001)/20.
phase_sc = 2*!pi*(time-20*fix(time/20.))
btrue_mag= 10+9.5* sin(2*!pi*time/50.)

plot, time,btrue_mag

bx_despun= true_x*btrue_mag+ offset_x*cos(phase_sc)
by_despun= true_y*btrue_mag+ offset_y*sin(phase_sc)
bz_despun= true_z*btrue_mag+ offset_z

apparent_bmag= (bx_despun^2+by_despun^2+bz_despun^2)^0.5

oplot, time , apparent_bmag, color=cs.red, linestyle=4
stop
ap_x_bunit=bx_despun/apparent_bmag
ap_y_bunit=by_despun/apparent_bmag
ap_z_bunit=bz_despun/apparent_bmag

phi_54_ap= atan(ap_y_bunit, ap_x_bunit)
theta_54_ap = acos(ap_z_bunit)

averaged_t=fltarr(999)
phi_out=fltarr(999)
theta_out=fltarr(999)
guard_phi_out=fltarr(999)
guard_theta_out=fltarr(999)


for jkl=0, 998 do begin
  t_in=time(jkl*20:(jkl+1)*20-1)
  phi_angle_54= phi_54_ap(jkl*20:(jkl+1)*20-1)
  theta_angle_54= theta_54_ap(jkl*20:(jkl+1)*20-1)

  rough_b_handler, t_in, phi_angle_54, theta_angle_54, average_phi, guard_phi,average_theta,$
    guard_theta, t_center_out
;
  phi_out(jkl)=average_phi
  theta_out(jkl)=average_theta
  guard_phi_out(jkl)=guard_phi
  guard_theta_out(jkl)=guard_theta
  averaged_t(jkl)=t_center_out
endfor
plot,  averaged_t, phi_out, ystyle=1, color = cs.red, psym=4, yrange=[0,60], xrange=[0,200]
oplot, averaged_t, phi_out+guard_phi_out, color = cs.red, linestyle=4
oplot, averaged_t, phi_out-guard_phi_out,  color = cs.red,linestyle=4
oplot, averaged_t, theta_out, psym=4,  color = cs.blue
oplot, averaged_t, theta_out+guard_theta_out, color = cs.blue,linestyle=4
oplot, averaged_t, theta_out-guard_theta_out,  color = cs.blue,linestyle=4

stop

end