pro boxcar_average, x_in, y_in, n_smooth, x_out, y_out, gaussian=gaussian,$
                                    m_width=m_width
;;;;;;;;;;;;
; +
; Straight Average, of +/- data with or without gaussian weights
;
;
;
;
;
; -
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
resid = n_smooth-(n_smooth/2)*2
if(resid ne 1) then n_smooth=n_smooth+1
npts=n_elements(x_in)
if(n_smooth gt npts) then begin
   print, 'smoothing interval larger than data interval'
   stop
   return
endif
ibegin=(n_smooth-1)/2
iend= npts-1-ibegin
x_out=0*x_in-1.0e31
y_out=0*y_in-1.0e31

weights=intarr(n_smooth)*0+1
if keyword_set(gaussian) then begin
  if not(keyword_set(m_width)) then begin
    print, 'gaussian width not provided for 
    stop
    return
  endif
  weights= exp(-((findgen(n_smooth)-ibegin)/(1.*m_width))^2)
endif
weights=weights/total(weights)

for jkl=ibegin, iend do begin

x_out(jkl)= total( x_in(jkl-ibegin:jkl+ibegin), /double)/ n_smooth
y_out(jkl)= total(y_in(jkl-ibegin:jkl+ibegin)*weights, /double)
endfor

x_out=x_out(ibegin:iend)
y_out=y_out(ibegin:iend)

end
