pro diagonal_binner, x_data, y_data, x_sigma, y_sigma, nparms_in, npts_group,$
                     slope_best, rchisq_best, error_out_minus_plus, $
                     iwant_plot_or_not, scatter=scatter, $
                     err_hdl=err_hdl, sdispersed_fac=sdispersed_fac
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Purpose: bin data along hypothetical line to give equal numbers
;         per bin with attendant uncertainties.
;
; Input Arguments:
;
;   x_data, y_data, x_sigma, y_sigma         - x,y,errors
;
;   nparms_in                                - 1=Slope of Line through Origin
;                                            - 2=Slope and Intercept
;
;   iwant_plot_or_not                        - 1 get diagnostics along the way
;                                            - 0 surpressed
;
;
; Output:
;
;   npts_group                               - # pts grouped when it stopped.
;   slope_best                               - Fit Slope
;   rchisq_best                              - Reduced Chisq
;   error_out_minus_plus                     - [ERR_low, ERR_high]
;
;   
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;     Technique:   x',y' = M(x, y-intercept)
;
;     Where M is the matrix that undoes the slope of the hypothesis
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fill=-1e31
err_hdl= -1

chisq_ref=1.0e31
x=x_data
y=y_data
sigma_x=x_sigma
sigma_y=y_sigma

x_in=x
y_in=y
sigx_in=sigma_x
sigy_in=sigma_y
icount=-1

mode=1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;coarse;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
gen_fit_release_jds,x=x_in,sigma_x=sigx_in, y=y_in, sigma_y=sigy_in,$
  nparms=nparms_in, guess_slope=mode, slope=slope, rchisq=rchisq, $
  intercept=intercept,$
  ks_c99=ks_c68, /force_kappa_search,status=status,s2= s2,$
  ks_range_degrees=[0.1,89.9], n_iterations=1000

if (n_elements(s2) gt 0) then begin
    sdispersed = sqrt(s2) gt 3
    sdispersedtrue = where(sdispersed eq 1, s2t_count)
    sdispersedfals = where(sdispersed eq 0, s2f_count)
    sdispersed_fac=float(s2t_count)/float(n_elements(s2))
endif else begin
    sdispersed_fac=1.1
endelse

if status eq 5 then begin
    print, 'Changing kappa_search Range and repeating...'
    gen_fit_release_jds,x=xbar,sigma_x=xdisp, y=ybar, sigma_y=ydisp,$
      nparms=nparms_in, guess_slope=mode, slope=slope, rchisq=rchisq,$
      ks_c99=ks_c68, /force_kappa_search,status=status,s2= s2,$
      ks_range_degrees=[0.1,89.95], n_iterations=1000    
endif
if status eq 2 then begin
    message, 'gen_fit_release fails with status = '+strtrim(status,2),/cont
    err_hdl= status
    return
endif
slope_hypo=slope
error_x_sort=ks_c68
chisq_x_sort=rchisq
chisq_raw=rchisq
if(nparms_in eq 1) then intercept_hypo=0
if(nparms_in eq 2) then intercept_hypo= intercept

;print, slope_hypo
;stop

branch: one=1
jmax=n_elements(x_in)/9
for jil=1,jmax do begin
    npts_group=2.0^jil

    if(iwant_plot_or_not eq 1) then $
      plot, x_data, y_data, psym=4, /xlog, /ylog

    angle=atan(slope_hypo)
    m=fltarr(2,2)
    m(0,0)=cos(angle)
    m(0,1)=sin(angle)
    m(1,0)=-m(0,1)
    m(1,1)=m(0,0)
    yinter=y_data-intercept_hypo
    xinter=x_data

    xprime= m(0,0)*xinter+ m(0,1)*yinter
    yprime= m(1,0)*xinter+ m(1,1)*yinter
;
; Now data are to be binned in xprime direction
;
;stop
    if(iwant_plot_or_not eq 1) then plot, xprime, yprime, psym=4, /xlog
;stop

    isort=sort(xprime)
    npts=n_elements(xprime)
;npts_group=80

    igroups=npts/npts_group
    x_out=fltarr(igroups)
    y_out=fltarr(igroups)
    dx_out=fltarr(igroups)
    dy_out=fltarr(igroups)

    for jkl=0,igroups-1 do begin
;;; now average the original points identified in these groups in gangs
        k_lower=npts-1-(jkl+1)*npts_group+1
        k_upper=npts-1-jkl*npts_group
        iwant=isort(k_lower:k_upper)
                                ;print, 'jkl=', jkl
                                ;print, 'klower,kupper:', k_lower,k_upper
                                ;print, iwant
        

        x_out(jkl)=total(x_data(iwant),/double)/npts_group
        y_out(jkl)=total(y_data(iwant),/double)/npts_group
        xg2=(x_data(iwant)-x_out(jkl))^2 + sigma_x(iwant)^2
        yg2=(y_data(iwant)-y_out(jkl))^2 + sigma_y(iwant)^2
        dx_out(jkl)=(total(xg2)/npts_group)^0.5
        dy_out(jkl)=(total(yg2)/npts_group)^0.5
                                ;print, 'averages'
                                ;print, x_out(jkl), y_out(jkl), dx_out(jkl), dy_out(jkl)
                                ;stop

    endfor
;stop
    if(iwant_plot_or_not eq 1) then plot,x_data, y_data,psym=4,/xlog, /ylog
;stop

    upper=max([max(x_data),max(y_data)])
;print, 'upper=', upper
;stop
    hydra_setcolors,cs
    if(iwant_plot_or_not eq 1) then $
      error_flags_jds, x_out,y_out, dx_out,dy_out, max=upper, min=1, $
      ioplot_or_not=0, $
      colorchoice='red', $
      xlog=1, ylog=1
;oplot,x_data, y_data,psym=4
    gen_fit_release_jds,x=x_out,sigma_x=dx_out, y=y_out, sigma_y=dy_out,$
      nparms=nparms_in, guess_slope=mode, slope=slope, rchisq=rchisq, $
      intercept=intercept,$
      ks_c99=ks_c68, /force_kappa_search,status=status,s2= s2,$
      ks_range_degrees=[0.1,89.9], n_iterations=1000
    if status eq 5 then begin
        print, 'Changing kappa_search Range and repeating...'
        gen_fit_release_jds,x=xbar,sigma_x=xdisp, y=ybar, sigma_y=ydisp,$
          nparms=nparms_in, guess_slope=mode, slope=slope, rchisq=rchisq,$
          ks_c99=ks_c68, /force_kappa_search,status=status,s2= s2,$
          ks_range_degrees=[0.1,89.95], n_iterations=1000
        
    endif
    slope_fit_linear_to_raw=slope
    if(nparms_in eq 1) then intercept_hypo=0
    if(nparms_in eq 2) then intercept_hypo= intercept
    
    error_x_sort=ks_c68
    chisq_x_sort=rchisq
    chisq_raw=rchisq
    new_target_slope=slope_fit_linear_to_raw
;print, 'original:', slope_hypo, REDCHISQ
    c1=x_data
    cc2=y_data
    if(iwant_plot_or_not eq 1) then oplot, c1, c1*new_target_slope
    if(iwant_plot_or_not eq 1) then $
      oplot, c1, c1*(new_target_slope-ks_c68(0)), color=cs.green
    if(iwant_plot_or_not eq 1) then $
      oplot, c1, c1*(new_target_slope+ks_c68(1)), color=cs.green
    icount=icount+1

;print, 'new:', icount, npts_group, new_target_slope, chisq_raw
    slope_hypo=new_target_slope
;stop
    if(chisq_raw lt chisq_ref) then begin
      ; print, 'new:', icount, npts_group, new_target_slope, chisq_raw,intercept_hypo
        slope_hypo=new_target_slope
        chisq_ref=chisq_raw
        slope_best=new_target_slope
        error_out_minus_plus=ks_c68
        rchisq_best=chisq_ref
        intercept_best=intercept_hypo
        if(iwant_plot_or_not eq 1) then oplot,x_data, y_data,psym=4,symsize=0.1
    endif
    if (chisq_ref lt 1) then begin
        npts_group=long(npts_group)

        if keyword_set(scatter) then begin
            error_flags, x_out,y_out, dx_out, dy_out, $
              max=10000, min=1, $
              ioplot_or_not=0, xlog=1, ylog=1
        endif

        err_hdl= 0
        if slope_best gt 10.0 then err_hdl=11
;        if n_elements(s2) gt 1 then begin
;            s2stats=moment(s2)
;            s2mean=s2stats[0]
;        endif else begin
;            s2mean=0
;        endelse

        return
    endif
endfor
slope_best=fill
error_out_minus_plus=replicate(fill,2)
rchisq_best=fill
intercept_best=fill
if keyword_set(npts_group) then begin
    npts_group=long(npts_group)
endif else begin
    npts_group=0L
endelse

end
