pro dilute, length, error, binsize, x_out, y_out
;
;  Purpose to take a vector of mean length= length
; 
;  and error= error and apportion this across binsize bins of
;    amplitude that reflects that uncertainty, so that 
;    in the composite distribution there is still only unit 
;    representation from the reading
;
if( error le binsize) then begin
   x_out=[length]
   y_out=1./binsize
   return
endif
a= length+error
b=length-error
bins= long( abs((b-a))/binsize+1l)
if (bins eq 1) then begin
  x_out= [length]
  y_out= 1/binsize
  return
end
vector_x= b + (b-a)/(bins-1)*intarr(bins)
vector_amp= 1/abs(b-a)
x_out=vector_x
y_out=vector_amp
;help, x_out,y_out
return
end
