pro error_flags_jds, x,y, dx_dum,dy_dum, max=max, min=min, $
                 ioplot_or_not=ioplot_or_not, $
                 colorchoice=colorchoice, $
                 xlog=xlog, ylog=ylog
n_check=n_elements(dx_dum)
if n_check eq 1 then begin
   dx=dx_dum*[1,1]
   dy=dy_dum*[1,1]
endif
if n_check eq 2 then begin
   dx= dx_dum-x
   dy= dy_dum-y
endif

;;;;;;;  modified 6/5/2002 to handle dx_dum with extremes.....

hydra_setcolors, cs
;stop
default='cs.green'
if keyword_set(colorchoice) then begin
    result=execute('default=cs.'+colorchoice)
;
    if(result eq 0) then message,'color assignment failed', /continue
endif
npts=n_elements(X)
if not keyword_set(ioplot_or_not) then begin
    plot, x, y, /NODATA, title='DATA', xlog=xlog, ylog=ylog, $
      xrange=[min,max], yrange=[min,max], xstyle=1, ystyle=1
    OPLOT, X,Y, PSYM=4,SYMSIZE=0.5
    XLOWER=X-Dx
    neg_x=where(xlower le 0, npts_x)
    if(npts_x gt 0) then xlower(neg_x)=1.0e-9
    XUPPER=X+Dx
    YLOWER=Y-DY
    neg_y=where(ylower lt 0,npts_y)
    if(npts_y gt 0) then ylower(neg_y) = 1.0e-9
    YUPPER=Y+DY
    FOR JKL=0, NPTS-1 DO BEGIN
        oplot,[XLOWER(jkl),XUPPER(jkl)],Y(jkl)*[1,1], color=default

        OPLOT,X(jkl)*[1,1],[YLOWER(jkl),YUPPER(jkl)], color=default


    ENDFOR
endif else begin
    OPLOT, X,Y, PSYM=4,COLOR=DEFAULT
    XLOWER=X-Dx
    neg_x=where(xlower le 0, npts_x)
    if(npts_x gt 0) then xlower(neg_x)=1.0e-9
    XUPPER=X+Dx
    YLOWER=Y-DY
    neg_x=where(xlower le 0, npts_x)
    if(npts_x gt 0) then xlower(neg_x)=1.0e-9
    YUPPER=Y+DY
    FOR JKL=0, NPTS-1 DO BEGIN
        oplot,[XLOWER(jkl),XUPPER(jkl)],Y(jkl)*[1,1], color=default

        OPLOT,X(jkl)*[1,1],[YLOWER(jkl),YUPPER(jkl)], color=default

                                ;stop
    ENDFOR



ENDELSE
end
