pro fitscreen, x, y, sigx, sigy, slope_out_best, error_slope_best, $
               chisq_out_best,$
               slope_x_sort, error_x_sort, chisq_x_sort,$
               slope_y_sort, error_y_sort, chisq_y_sort,$
               slope_fit_linear_to_raw, error_raw, chisq_raw, $
               xaverage_save, xdisp_save, $
               yaverage_save, ydisp_save,plot=plot, $
               kappa_data_out= kappa_data, $
               x_out=x_out, y_out=y_out, $
               sigx_out= sigx_out, $
               sigy_out= sigy_out, $
               ks_c99= ks_c99, $
               ks_c68= ks_c68, $
               s2=s2_out

;
;
weighted_average=0
verbose=0
;;stop
; purpose to study how to get best linear fit for data through the
; origin with data that is just gathered in pairs but may be oversampled
;  in specific regions.........
;;;;;
;;     Approach: Create Buckets and Make Averages in Two Orthogonal Directions
;;;;;
;;;;;  Size of Buckets?  Sqrt{(n_l+n_u)/2} = (n_u-n_l)/2.
;;;;;
;;;;;
n_l=0l
icount=lonarr(180)
for jkl=0,179 do begin
    a=0.25
    b=(-n_l/2.-0.5)
    c= (n_l^2/4.-n_l/2.)
;
    nu_plus=(-b + (b^2-4*a*c)^0.5 ) /2/a


    icount(jkl)=long(nu_plus)
    n_l=icount(jkl)
;print, 'jkl, nu(jkl):', jkl, icount(jkl), nu_plus
;
;print, nu_plus, nu_minus
;stop

endfor
;stop

if keyword_set(weighted_average) then begin
    wx=1.0/sigx^2
    wy=1.0/sigy^2
endif else begin
    wx=1.0
    wy=1.0
endelse
;
;     Bin in x
;

ifit_points=-1
ibucket=where(x ge 0 and x lt icount(0),npts_0)
if(npts_0 gt 3) then begin
    weightx=total(wx(ibucket), /double)
    weighty=total(wy(ibucket), /double)

    avey=total(y(ibucket)*wy(ibucket), /double)/weighty
    avex=total(x(ibucket)*wx(ibucket), /double)/weightx
    dispy= (total(((y(ibucket)-avey)^2+sigy(ibucket)^2)*wy(ibucket))/$
            weighty)^0.5
    dispx= (total(((x(ibucket)-avex)^2+sigx(ibucket)^2)*wx(ibucket))/$
            weightx)^0.5
    if keyword_set(plot) then begin
        print,"first fill in x binning"
        print, 'variance of y raw counts=', (total((y(ibucket)-avey)^2 )/npts_0)^0.5
        print, 'average raw count variance=' , (total(sigy(ibucket)^2)/npts_0)^0.5
        print, 'avey', avey
    endif
    if keyword_set(verbose) then begin
        print, 'x: ', '0', avex, dispx, avey, dispy
    endif

    ybar=[avey]
    ydisp=[dispy]
    xbar=[avex]
    xdisp=[dispx]
    ifit_points=0
    number_points=[npts_0]
endif
for jkl=0,178 do begin
    ibucketx= where(x ge icount(jkl) and x lt icount(jkl+1), npts_bucket)
    if(npts_bucket gt 3) then begin
        weightx=total(wx(ibucketx), /double)
        weighty=total(wy(ibucketx), /double)

        yave=total(y(ibucketx)*wy(ibucketx), /double)/weighty
        xave=total(x(ibucketx)*wx(ibucketx), /double)/weightx

        dispy= (total(((y(ibucketx)-yave)^2+sigy(ibucketx)^2)*wy(ibucketx))$
                /weighty)^0.5
        dispx= (total(((x(ibucketx)-xave)^2+sigx(ibucketx)^2)*wx(ibucketx))$
                /weightx)^0.5
        if keyword_set(verbose) then begin
            print, 'x: ', jkl, xave, dispx, yave, dispy
            if dispx gt xave or dispy gt yave then stop
        endif
        if(ifit_points eq -1) then begin
            xbar=[xave]
            xdisp=[dispx]
            ybar=[yave]
            ydisp=[dispy]
            ifit_points=0
            number_points=[npts_bucket]
            if keyword_set(plot) then begin
                print,"first fill in x binning"
                print, 'variance of y raw counts=', (total((y(ibucketx)-yave)^2 )/npts_0)^0.5
                print, 'average raw count variance=' , (total(sigy(ibucketx)^2)/npts_0)^0.5
                print, 'avey=', yave
            endif

        endif else begin
            xbar=[xbar,xave]
            xdisp=[xdisp,dispx]
            ybar=[ybar,yave]
            ydisp=[ydisp, dispy]
            ifit_points=ifit_points+1
            number_points=[number_points,npts_bucket]
        endelse
    endif
endfor
fudge= 1
;---------------------
if n_elements(ydisp) eq 0 or n_elements(xdisp) eq 0 then begin
    xdisp=sigx
    ydisp=sigy
    xbar=x
    ybar=y
    ifit_points=n_elements(x)-1
endif
;---------------------
ydisp=ydisp/fudge
xdisp=xdisp/fudge
n_fit_points_x=n_elements(xbar)
hydra_setcolors,cs
xbar=xbar(0:ifit_points)
ybar=ybar(0:ifit_points)
xdisp=xdisp(0:ifit_points)
ydisp=ydisp(0:ifit_points)

the_maximum=max([max(ybar),max(xbar)])

if keyword_set(plot) then begin
    plot, xbar,ybar,/nodata, xrange=[0.1,1.1*the_maximum], $
      yrange=[0.1,1.1*the_maximum]  ,$
      /xlog,/ylog

                                ;help, xbar, ybar, xdisp, ydisp
                                ;stop

    error_flags  ,xbar,ybar,xdisp,ydisp,ioplot_or_not=1,colorchoice='orange'
    print, 'stopping after first call to error_flags!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
                                ; stop

endif

mode=1
isave=where(x ne 0, npts_save)
if(npts_save gt 0 ) then begin

    ratio= y(isave)/x(isave)
    mode=total(ratio)/npts_save
endif

;print, 'mode guess=', mode

                                ; ;stop
;help, x,y, sigx, sigy
;stop




gen_fit_release_jds,x=xbar,sigma_x=xdisp, y=ybar, sigma_y=ydisp,$
  nparms=1, guess_slope=mode, slope=slope, rchisq=rchisq,$
  ks_c99=ks_c68, /force_kappa_search,status=status,s2= s2,$
  ks_range_degrees=[0.1,89.9], n_iterations=1000
if status eq 5 then begin
    print, 'Changing kappa_search Range and repeating...'
    gen_fit_release_jds,x=xbar,sigma_x=xdisp, y=ybar, sigma_y=ydisp,$
      nparms=1, guess_slope=mode, slope=slope, rchisq=rchisq,$
      ks_c99=ks_c68, /force_kappa_search,status=status,s2= s2,$
      ks_range_degrees=[0.1,89.95], n_iterations=1000
    
endif
slope_x_sort=slope
error_x_sort=ks_c68
chisq_x_sort=rchisq
if keyword_set(plot) then begin
    print, 'gen_fit_release_jds_io='
    print, 'slope=', slope
    print, '99% range of slope=',ks_c68
    oplot, [.1,10000.], slope*[.1,10000.], color=cs.orange
    oplot, [.1,10000.], (slope+ks_c68(0))*[.1,10000.], color=cs.orange
    oplot, [.1,10000.], (slope-ks_c68)*[.1,10000.], color=cs.orange
endif
;help, ifit_points, xbar, ybar, xdisp, ydisp

;print, 'deviants:', s2

;stop

;stop
xaverage_save=[xbar]
yaverage_save=[ybar]
xdisp_save=[xdisp]
ydisp_save=[ydisp]


;
;     Bin in y
;

ifit_points=-1
ibucket=where(y ge 0 and y lt icount(0),npts_0)
if(npts_0 gt 3) then begin
    weightx=total(wx(ibucket), /double)
    weighty=total(wy(ibucket), /double)

    avey=total(y(ibucket)*wy(ibucket), /double)/weighty
    avex=total(x(ibucket)*wx(ibucket), /double)/weightx

    dispx= (total(((x(ibucket)-avex)^2 +sigx(ibucket)^2)*wx(ibucket))/$
            weightx)^0.5
    dispy= (total(((y(ibucket)-avey)^2 +sigy(ibucket)^2)*wy(ibucket))/$
            weighty)^0.5
    if keyword_set(verbose) then begin
        print, 'y: ', '0', avex, dispx, avey, dispy
    endif
    xbar=[avex]
    ybar=[avey]
    ydisp=[dispy]
    xdisp=[dispx]
    ifit_points=0
    number_points=[npts_0]
    if keyword_set(plot) then begin
        print,'first fill in y binning'
        print, 'variance of raw counts=', (total((x(ibucket)-avex)^2 )/npts_0)^0.5
        print, 'average raw count variance=' , (total(sigx(ibucket)^2)/npts_0)^0.5
    endif
endif
for jkl=0,178 do begin
    ibuckety= where(y ge icount(jkl) and y lt icount(jkl+1), npts_bucket)
    if(npts_bucket gt 3) then begin
        weightx=total(wx(ibuckety), /double)
        weighty=total(wy(ibuckety), /double)

        yave=total(y(ibuckety)*wy(ibuckety), /double)/weighty
        xave=total(x(ibuckety)*wx(ibuckety), /double)/weightx

        dispx= (total(((x(ibuckety)-xave)^2 +sigx(ibuckety)^2)*wx(ibuckety))$
                /weightx)^0.5
        dispy= (total(((y(ibuckety)-yave)^2 +sigy(ibuckety)^2)*wy(ibuckety))$
                /weighty)^0.5
        if keyword_set(verbose) then begin
            print, 'y: ', jkl, xave, dispx, yave, dispy
            if dispx gt xave or dispy gt yave then stop
        endif
        if(ifit_points eq -1) then begin
            xbar=[xave]
            xdisp=[dispx]
            ybar=[yave]
            ydisp=[dispy]
            ifit_points=0
            number_points=[npts_bucket]
            if keyword_set(plot) then begin
                print,'first fill in y binning'
                print, 'variance of raw counts=', (total((x(ibuckety)-xave)^2 )/npts_0)^0.5
                print, 'average raw count variance=' , (total(sigx(ibuckety)^2)/npts_0)^0.5
            endif 
        endif else begin
            xbar=[xbar,xave]
            xdisp=[xdisp,dispx]
            ybar=[ybar,yave]
            ydisp=[ydisp, dispy]
            number_points=[number_points, npts_bucket]
            
        endelse
    endif
                                ;print, 'jkl, npts_bucket,', jkl, npts_bucket,xave,dispx,yave,disp
    
endfor
fudge=1
xdisp=xdisp/fudge
ydis=ydisp/fudge
n_fit_points_y=n_elements(xbar)
ratio= ybar/xbar
mode=total(ratio)/n_fit_points_x
;print, 'mode guess=', mode

                                ; ;stop
;help,xbar, ybar, xdisp, ydisp
;stop

if keyword_set(plot) then begin
    error_flags,xbar,ybar,xdisp,ydisp,ioplot_or_not=1,colorchoice='yellow'
endif
;stop
ks_range_deg=[0.1, 89.9]
gen_fit_release_jds,x=xbar,sigma_x=xdisp, y=ybar, sigma_y=ydisp,$
  nparms=1, guess_slope=mode, slope=slope, rchisq=rchisq,$
  ks_c99=ks_c99,ks_c68=ks_c68, /force_kappa_search,status=status,s2=s2,$
  ks_range_degrees=ks_range_deg, n_iterations=1000
slope_x_vs_y=slope
slope_y_sort=slope
error_y_sort=ks_c99
chisq_y_sort=rchisq
if keyword_set(plot) then begin
    print, '68% confidence=', ks_c68
    print, '99% confidence=', ks_c99
    print, 'gen_fit_release_jds_io='
    print, 'slope=', slope
    oplot, [.1,10000.], slope*[.1,10000.], color=cs.yellow
    oplot, [.1,10000.], (slope+ks_c99(0))*[.1,10000.], color=cs.yellow
    oplot, [.1,10000.], (slope-ks_c99(1))*[.1,10000.], color=cs.yellow
endif
;help, ifit_points, xbar, ybar, xdisp, ydisp

;print, 'deviants:', s2


;stop
;    fit_linear_slope, xbar, ybar, xdisp, ydisp, peak, $
;      error, rchisq, s2=s2,  $
;      guess=mode,robust_cut=0, $
;      fit_indices=fit_indices;, $
;      ;robust_status=robust_status

if keyword_set(plot) then begin
    oplot, [.1,10000.], slope_x_vs_y*[.1,10000.], color=cs.cyan
    print, 'bucketing in y results'
                                ;print, 'slope =' , peak
                                ;print, 'errorin slope/percent=', error/peak*100.
                                ;print, 'rchisq=', rchisq
endif
;;;;;;;;;;;;above;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

xaverage_save=[xaverage_save,xbar]
yaverage_save=[yaverage_save,ybar]
xdisp_save=[xdisp_save,xdisp]
ydisp_save=[ydisp_save, ydisp]

mode=total(yaverage_save/xaverage_save)/n_elements(xaverage_save)

gen_fit_release_jds,x=xaverage_save,sigma_x=xdisp_save, y=yaverage_save, $
  sigma_y=ydisp_save,$
  nparms=1, guess_slope=mode, slope=slope, rchisq=rchisq,$
  ks_c99=ks_c99,ks_c68=ks_c68, /force_kappa_search,status=status,s2= s2,$
  ks_range_degrees=[0.1,89.9], kappa_data= kappa_data, n_iterations=1000
x_out= xaverage_save
sigx_out= xdisp_save
y_out= yaverage_save
sigy_out= ydisp_save

slope_out_best=slope
;error_slope_best=ks_c99
error_slope_best=ks_c68
chisq_out_best=rchisq
s2_out=s2
if keyword_set(plot) then begin

    print, 'error in fit constants 2nd time'
    print, '68%=', ks_c68
    print, '99%', ks_c99
                                ;stop

    print, 'composite fit summary follows'
    print, 'slope=', slope
    print, 'error 68%=', ks_c68
    print, 'reduced chisq=', rchisq
    oplot, [.1,10000.], slope*[.1,10000.], color=cs.red
    oplot, [.1,10000.], (slope-ks_c99(0))*[.1,10000.], color=cs.red
    oplot, [.1,10000.], (slope+ks_c99(1))*[.1,10000.], color=cs.red
endif

if keyword_set(residual_plot) then begin
;   fit_linear_slope, x, y, sigx, sigy, peak, $
;      error, rchisq, s2=s2,  $
;      guess=slope_out_best,robust_cut=0, $     ; turns off robust fitting
;      fit_indices=fit_indices ; , $
;     ; robust_status=robust_status

;stop ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;determine residuals contributing to chi square from the slope_out_best fitl
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    s2=(slope_out_best*x-y)^2/(sigy^2+(slope_out_best*sigx)^2)
;print,'linear slope back with residuals from fit'


    iplus=where(y gt slope_out_best*x, npts_1)
    iminus=where(y le slope_out_best*x, npts_2)
    if(npts_1 gt 0 and npts_2 gt 0) then begin
        s2(iminus)=-s2(iminus)
        histogram_rdh, s2, xt, yt, binsize=0.01
        !p.multi=[0,1,4]
        plot, xt, yt, psym=10, title='!17 Residuals re Binned Fit of Raw'
        plot, xt, yt, psym=10, xrange=[-10, 10],xstyle=1
        imax=where(yt eq max(yt))
        nx=n_elements(xt)
        n_new=nx+1
        ytemp=0*yt(imax(0):nx-1)
        yt2=0*yt
        itemp=nx-2-imax(0)
        if(itemp gt imax(0)) then itemp=imax(0)
        for jkl=0L, itemp do begin
            ytemp(jkl)= yt(imax(0)-jkl)
            yt2(jkl+imax(0))=yt(imax(0)-jkl)
            yt2(imax(0)-jkl)=yt(imax(0)-jkl)
        endfor
        plot, xt(imax(0):nx-1)-xt(imax(0)), yt(imax(0):nx-1)-ytemp ,xrange=[0,10]
        hydra_setcolors,cs
        plot, xt,yt
        oplot, xt, yt2, color=cs.red
        isave=where(yt gt yt2 and xt gt 0, npts_over)
        help, isave
        print, min(xt(isave))
        print, 'fraction = outliers', total(yt(isave))/total(yt)*100.
        help, x,y,sigx,sigy
                                ; stop
    endif
    !p.multi=0
endif
;stop


slope_fit_linear_to_raw=-1.0e31
error_raw=-1.0e31
chisq_raw=-1.0e31

;print, 'results of robust fitting:'
;print, 'slope', peak
;print, 'error in slope=', error

slope_y_vs_x=-1.0e31
error_slope_y_x=-1.0e31
chi_square_y_vs_x=-1.0e31





;stop






;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

end
