pro fitscreen_wrap, x, y, sigx, sigy, $
                    slope_out, slope_error_out, rchisq_out, $
                    plot=plot, log_plot=log_plot, $
                    kappa_data_out= kappa_data, $
                    x_out=x_out, y_out=y_out, $
                    sigx_out= sigx_out, $
                    sigy_out= sigy_out, $
                    ks_c99= ks_c99, $
                    ks_c68= ks_c68, $
                    s2=s2, $
                    xout=xaverage_save, yout=yaverage_save, $
                    xrange=xrange, yrange=yrange, $
                    normalize=normalize, $
                    _extra=e
;restore, filename='jack_12.idlsav', /verbose
;help
;stop
;x=c1
;y=c2
;sigx=sigma_c1
;sigy=sigma_c2
if keyword_set(normalize) then begin
    mode=1.0
    gen_fit_release_jds,x=x,sigma_x=sigx, y=y, sigma_y=sigy,$
      nparms=1, guess_slope=mode, slope=slope, rchisq=rchisq,$
      ks_c99=ks_c99, ks_c68=ks_c68, /force_kappa_search, $
      status=status,s2= s2,$
      ks_range_degrees=[0.1,89.9]
    if status ne 1 then begin
        print, 'gen_fit_failed: Using 1.0.'
        xp=x
        yp=y
        sigxp=sigx
        sigyp=sigy
    endif else begin
        print, 'Initial slope:', slope, rchisq
        xp=x
        yp=y/slope
        sigxp=sigx
        sigyp=sigy/slope
    endelse
endif else begin
    xp=x
    yp=y
    sigxp=sigx
    sigyp=sigy
endelse    
fitscreen, xp, yp, sigxp, sigyp, $
  slope_out, slope_error_out2, rchisq_out, $    
  slope_x_sort, error_x_sort, chisq_x_sort,$ ; ignore
  slope_y_sort, error_y_sort, chisq_y_sort,$ ; ignore
  slope_fit_linear_to_raw, error_raw, chisq_raw, $
  xaverage_save, xdisp_save, $
  yaverage_save, ydisp_save,plot=plot, $
  kappa_data_out= kappa_data, $
  x_out=x_out, y_out=y_out, $
  sigx_out= sigx_out, $
  sigy_out= sigy_out, $
  ks_c99= ks_c99, ks_c68= ks_c68, s2=s2

if keyword_set(normalize) then begin
    print, slope_out*slope, slope_error_out2(0)*slope, rchisq_out
    while abs(slope_out-1.0) gt 0.1 do begin
        yp=yp/slope_out
        sigyp=sigyp/slope_out
        slope=slope*slope_out
        fitscreen, xp, yp, sigxp, sigyp, $
          slope_out, slope_error_out2, rchisq_out, $    
          slope_x_sort, error_x_sort, chisq_x_sort,$ ; ignore
          slope_y_sort, error_y_sort, chisq_y_sort,$ ; ignore
          slope_fit_linear_to_raw, error_raw, chisq_raw, $
          xaverage_save, xdisp_save, $
          yaverage_save, ydisp_save,plot=plot, $
          kappa_data_out= kappa_data, $
          x_out=x_out, y_out=y_out, $
          sigx_out= sigx_out, $
          sigy_out= sigy_out, $
          ks_c99= ks_c99, ks_c68= ks_c68, s2=s2
        print, slope_out*slope, slope_error_out2(0)*slope, rchisq_out
    endwhile
endif


slope_error_out= max( slope_error_out2 )
  
if keyword_set(normalize) then begin

    slope_out=slope_out*slope
    slope_error_out=slope_error_out*slope
    ks_c99= ks_c99*slope
    ks_c68= ks_c68*slope

    yaverage_save=yaverage_save*slope
    ydisp_save=ydisp_save*slope
endif


  if keyword_set(log_plot) then begin

      error_flags, xaverage_save, yaverage_save, $
        xdisp_save, ydisp_save, /xlog, /ylog, $
        min=xrange(0), max=xrange(1)

      x1=10^total(!x.crange*[0.9,0.1])
      y1=10^total(!y.crange*[0.1,0.9])
      xyouts, x1, y1, 'Slope='+strtrim(string(slope_out,format='(f10.3)'),2)

      x2=10^total(!x.crange*[0.9,0.1])
      y2=10^total(!y.crange*[0.2,0.8])
      xyouts, x2, y2, 'Error='+$
        strtrim(string(max(slope_error_out2),format='(f10.3)'),2)

      x3=10^total(!x.crange*[0.9,0.1])
      y3=10^total(!y.crange*[0.3,0.7])
      xyouts, x3, y3, 'Rchisq='+strtrim(string(rchisq_out,format='(f10.3)'),2)


      oplot, 10^!x.crange, slope_out*10^!x.crange, linestyle=1


  endif


;print, 'received data across interface'

;print, slope_out
;print, slope_error_out
;print, rchisq_out


end
