;***PURPOSE:  CREATE A CONTOUR MAP OF THE JUMP IN NORMAL B ACROSS THE SHOCK
;             AS A FUNCTION OF THE ORIENTATION OF THE SHOCK NORMAL


FUNCTION cross, x,y
result = [x(1)*y(2) - x(2)*y(1),x(2)*y(0) - x(0)*y(2),$
x(0)*y(1)- x(1)*y(0)]
return, result
end

FUNCTION mag,x
result = sqrt(total(x*x))
return, result
end

FUNCTION PERR, A,B,DA,DB
;***PURPOSE: COMPUTE THE ERROR OF THE PRODUCT OF TWO STATISTICALLY INDEPENDENT
;            QUANTITIES


RESULT = SQRT((A*DB)^2 + (DA*B)^2)

RETURN,RESULT
END


FUNCTION SERR,DA,DB
;***PURPOSE: COMPUTE THE ERROR OF THE SUM OR DIFFERENCE OF TWO STATISTICALLY
;            INDEPENDENT QUANTITIES.
 
RESULT = SQRT(DA^2 + DB^2)

RETURN,RESULT
END

FUNCTION VERR,A,DA
;***PURPOSE: COMPUTE THE UPPER BOUND OF THE UNCERTAINTY IN A VECTOR QUANTITY

RESULT = TOTAL(A*DA)/MAG(A)
RETURN,RESULT

END

FUNCTION CROSSERR,A,B,DA,DB
;***PURPOSE: COMPUTE THE ERROR OF THE MAGNITUDE OF THE CROSS PRODUCT 
;            OF TWO VECTORS
;            INPUT:
;                    A,B = 3 ELEMENT ARRAYS
;                    DA,DB = 3 ELEMENT ARRAYS CONTAINING ERRORS
;
;            OUTPUT:
;                    D|A X B| = (A X B)*D(A X B)/|A X B|

VECT = DBLARR(3)
DVECT = DBLARR(3)

VECT = CROSS(A,B)
print,a
print,b
print,vect
DAXBY = PERR(A(0),B(1),DA(0),DB(1))
DAXBZ = PERR(A(0),B(2),DA(0),DB(2))
DAYBX = PERR(A(1),B(0),DA(1),DB(0))
DAYBZ = PERR(A(1),B(2),DA(1),DB(2))
DAZBX = PERR(A(2),B(0),DA(2),DB(0))
DAZBY = PERR(A(2),B(1),DA(2),DB(1))

DVECT(0) = SERR(DAYBZ,DAZBY)
DVECT(1) = SERR(DAXBZ,DAZBX)
DVECT(2) = SERR(DAXBY,DAYBX)

print,dvect

RESULT = TOTAL(VECT*DVECT)/MAG(VECT)

RETURN,RESULT
END


FUNCTION MIN2D,A
;**PURPPOSE: FIND THE MINIMUM OF A 2D ARRAY
;            RETURNS A VECTOR OF 2 ELEMENTS CORRESPONDING TO THE 
;            ROW AND COLLUMN INDECIES OF THE MINIMUM.

DIM = SIZE(A)
TEMP = DBLARR(DIM(1))
INDEX = INTARR(DIM(1))

FOR I = 0,DIM(1)-1 DO BEGIN
   TEMP(I) = MIN(A(I,*))
   INDEX(I) = WHERE(A(I,*) EQ MIN(A(I,*)))
ENDFOR

INDR = WHERE(TEMP EQ MIN(TEMP))
INDC = INDEX(INDR)

RETURN, [INDR,INDC]
END
;===================================================================
; MAIN PROGRAM
;===================================================================

;BU = UPSTREAM MAGNETIC FIELD VECTOR
;BD = DOWNSTREAM MAGNETIC FIELD VECTOR
;DB = BD - BU
;THETA = POLAR ANGLE OF MAGNETIC FIELD 
;PHI = AZMUTHAL ANGLE OF MAGNETIC FIELD
;VU = UPSTREAM VELOCITY
;VD = DOWNSTREAM VELOCITY
;DV = VD - VU
;DBDV = DB X DV
;BUBD = BU X BD
;R = 3 X 3 ROTATION MATRIX: INERTIAL -> LAB FRAME WITH B ALONG Z AXIS
;IR = TRANSPOSE OF R


PI = ACOS(-1.D0)

;FIELD DATA(TEST DATA)
BU = [5D-5,8.6603D-5,0.]
BD = [5D-5,1.11678D-4,0]

SIGBU = .5*[1.D-5,1.D-5,1.D-5]    ;ASSUMED FROM GALILEO DATA 
SIGBD = .5*[1.D-5,1.D-5,1.D-5]

DB = BD - BU
SIGDB = SERR(SIGBD,SIGBU)

THETA = ACOS(BU(2)/MAG(BU))
PHI = ATAN(BU(1),BU(0))

;VELOCITY DATA(TEST DATA)
VU = [3.02916D7,0.0,0.0]
VD = [1.06986D7,.221348D7,0.0]
SIGVU = [2.5D6,2.5D6,2.5D6]
SIGVD = [2.5D6,2.5D6,2.5D6]

DV = VD - VU
SIGDV = SERR(SIGVD,SIGVU)

DBDV = CROSS(DB,DV)

BUBD = CROSS(BU,BD)

BUDV = CROSS(BU,DV)

;FIND ROTATION MATRIX WHICH TRANSFORMS NORMAL TO GSE COORDINATES

A = DBLARR(3,3)
C = DBLARR(3,3)

A(0,0) = COS(PHI)
A(0,1) = SIN(PHI)
A(0,2) = 0D0
A(1,0) = -SIN(PHI) 
A(1,1) = COS(PHI)
A(1,2) = 0D0
A(2,0) = 0D0
A(2,1) = 0D0
A(2,2) = 1D0

C(0,0) = COS(THETA)
C(0,1) = 0D0
C(0,2) = -SIN(THETA)
C(1,0) = 0D0 
C(1,1) = 1D0
C(1,2) = 0D0
C(2,0) = SIN(THETA)
C(2,1) = 0D0
C(2,2) = COS(THETA)

R = C#A 
IR = TRANSPOSE(R)       ;ROTATION TO GSE COORDINATE



THETA_BNDIM = 100
RHODIM = 100

THETA_BN = DBLARR(THETA_BNDIM + 1)
RHO = DBLARR(RHODIM + 1)
JBN = DBLARR(THETA_BNDIM + 1,RHODIM+1)
JBT = DBLARR(THETA_BNDIM + 1,RHODIM+1)
DBDVN = DBLARR(THETA_BNDIM + 1,RHODIM+1)
BUXBD = DBLARR(THETA_BNDIM + 1,RHODIM+1)
BUDVN = DBLARR(THETA_BNDIM + 1,RHODIM+1)

THETA_BNMIN = 0D0
THETA_BNMAX = PI
RHOMAX = 2D0*PI
RHOMIN = 0D0

THETA_BNSTEP = (THETA_BNMAX - THETA_BNMIN)/DOUBLE(THETA_BNDIM)
RHOSTEP = (RHOMAX - RHOMIN)/DOUBLE(RHODIM)


FOR I = 0, THETA_BNDIM DO BEGIN
   THETA_BN(I) = THETA_BNMIN + I*THETA_BNSTEP
   STHETABN = SIN(THETA_BN(I))
   CTHETABN = COS(THETA_BN(I))
   FOR J = 0, RHODIM DO BEGIN
     RHO(J) = RHOMIN + J*RHOSTEP
     NORM = IR#[STHETABN*COS(RHO(J)),STHETABN*SIN(RHO(J)),CTHETABN]
     T = CROSS(NORM,BU)/MAG(BU)
     JBN(I,J) = ABS(TOTAL(-DB*NORM))/MAG(-DB)
     JBT(I,J) = ABS(TOTAL(-DB*T))/MAG(-DB)
     DBDVN(I,J) = ABS(TOTAL(DBDV*NORM))/MAG(DBDV)
     BUDVN(I,J) = ABS(TOTAL(BUDV*NORM))/MAG(BUDV)
     BUXBD(I,J) = ABS(TOTAL(BUBD*NORM))/MAG(BUBD)
   ENDFOR
ENDFOR


SIGDBDVN = CROSSERR(DB,DV,SIGDB,SIGDV)/MAG(DBDV)
SIGBUXBD = CROSSERR(BU,BD,SIGBU,SIGBD)/MAG(BUBD)
SIGJBN = VERR(DB,SIGDB)/MAG(DB)
SIGBUDVN = CROSSERR(BU,DV,SIGBU,SIGDV)/MAG(DBDV)

;INDEX = MIN2D(JBN)
;PRINT,'JBNMIN = ',JBN(INDEX(0),INDEX(1))
;PRINT,'THETA_BN = ',THETA_BN(INDEX(0))*180/PI
;PRINT,'RHO = ',RHO(INDEX(1))*180/PI

;STHETABN = SIN(THETA_BN(INDEX(0)))
;CTHETABN = COS(THETA_BN(INDEX(0)))
;CRHO = COS(RHO(INDEX(1)))
;SRHO = SIN(RHO(INDEX(1)))

;NORM = IR#[STHETABN*CRHO,STHETABN*SRHO,CTHETABN]

;THETABN = ACOS(TOTAL(BU*NORM)/MAG(BU))*180/PI


LEVJBN = [5D-3, 5D-3 + SIGJBN]
LEVJBT = 1D-4
LEVDBDVN = [1D-4, 1D-4 + SIGDBDVN]

SET_PLOT,'PS'
DEVICE,/LANDSCAPE,FILENAME = 'jbn.ps'

;;JBN & JBT CONTOUR PLOT
;CONTOUR,JBN,THETA_BN*180/PI,RHO*180/PI,NLEVELS = 10,/FOLLOW $
;,XTITLE = '!7H!17!DBn!N (DEG)', YTITLE = '!7q!17 (DEG)' $
;,TITLE = '!17LEVEL CURVES OF !7D!17B!9.!17n AND !7D!17B!9.!17t'
;CONTOUR,JBN,THETA_BN*180/PI,RHO*180/PI,LEVELS = LEVJBN,/NOERASE
;CONTOUR,JBT,THETA_BN*180/PI,RHO*180/PI,NLEVELS = 10,/FOLLOW $
;,C_LINESTYLE = 4,/NOERASE
;CONTOUR,JBT,THETA_BN*180/PI,RHO*180/PI,LEVELS = LEVJBT $
;,C_LINESTYLE = 4,/NOERASE

; JBN & DBDVN CONTOUR PLOT
CONTOUR,JBN,THETA_BN*180/PI,RHO*180/PI,LEVELS = LEVJBN,/FOLLOW $
,XTITLE = '!7H!17!DBn!N (DEG)', YTITLE = '!7q!17 (DEG)' $
,TITLE = $
'!17LEVEL CURVES OF !7D!17B!9.!17n AND (!7D!17B!9X!7D!17V)!9.!17n' $
,C_LABELS = [1,1]
CONTOUR,DBDVN,THETA_BN*180/PI,RHO*180/PI,LEVELS = LEVDBDVN,/FOLLOW $
,C_LINESTYLE = 4,C_LABELS = [1,1],/NOERASE

DEVICE,/CLOSE
;SPAWN,'lpr jbn.ps'

SET_PLOT,'X'

;JBN & BUDVN CONTOUR PLOT
CONTOUR,JBN,THETA_BN*180/PI,RHO*180/PI,LEVELS = LEVJBN,/FOLLOW $
,XTITLE = '!7H!17!DBn!N (DEG)', YTITLE = '!7q!17 (DEG)' $
,TITLE = $
'!17LEVEL CURVES OF !7D!17B!9.!17n AND (!7D!17B!9X!7D!17V)!9.!17n' $
,C_LABELS = [1,1]
CONTOUR,BUDVN,THETA_BN*180/PI,RHO*180/PI,LEVELS = LEVDBDVN,/FOLLOW $
,C_LINESTYLE = 4,C_LABELS = [1,1],/NOERASE

;;JBN & DBDVN CONTOUR PLOT
;CONTOUR,JBN,THETA_BN*180/PI,RHO*180/PI,LEVELS = LEVJBN,/FOLLOW $
;,XTITLE = '!7H!17!DBn!N (DEG)', YTITLE = '!7q!17 (DEG)' $
;,TITLE = $
;'!17LEVEL CURVES OF !7D!17B!9.!17n AND (!7D!17B!9X!7D!17V)!9.!17n' $
;,C_LABELS = [1,1]
;CONTOUR,DBDVN,THETA_BN*180/PI,RHO*180/PI,LEVELS = LEVDBDVN,/FOLLOW $
;,C_LINESTYLE = 4,C_LABELS = [1,1],/NOERASE

;;JBN & JBT CONTOUR PLOT
;CONTOUR,JBN,THETA_BN*180/PI,RHO*180/PI,NLEVELS = 10,/FOLLOW $
;,XTITLE = '!7H!17!DBn!N (DEG)', YTITLE = '!7q!17 (DEG)' $
;,TITLE = '!17LEVEL CURVES OF !7D!17B!9.!17n AND !7D!17B!9.!17t'
;CONTOUR,JBT,THETA_BN*180/PI,RHO*180/PI,NLEVELS = 10,/FOLLOW $
;,C_LINESTYLE = 4,/NOERASE
;CONTOUR,JBT,THETA_BN*180/PI,RHO*180/PI,LEVELS = LEVJBT $
;,C_LINESTYLE = 4,/NOERASE


END


