pro mod_delta_noisy, x1,y1, x2, y2, dx_averaged,dy_averaged,$
                       variance_x, variance_y, $
                   dx_of_averages,dy_of_averages,$
                  ave_x1, ave_y1, ave_x2,ave_y2
;
;
; purpose take two noisy 2d vectors in and consider all possible deltas between
; the groups and report the average delta and the delta of the respective averages
; as well as the variances on the deltas... intended to be used when comparing
;  ExB drifts with U_perp electrons..........
;
fill = 1e10
dx_averaged=-1e31
dy_averaged=-1e31
variance_x=-1e31
variance_y=-1e31
dx_of_averages=-1e31
dy_of_averages=-1e31
ave_x1=-1e31
ave_y1=-1.0e31
ave_x2=-1.0e31
ave_y2=-1.0e31
;
;  default load for return
;
igood_1=where(abs(x1) lt  fill and abs(y1) lt fill, npts_1)
igood_2=where(abs(x2) lt  fill and abs(y2) lt fill, npts_2)
if(npts_1*npts_2 eq 0) then return
ave_x1=total(x1(igood_1))/npts_1
ave_y1=total(y1(igood_1))/npts_1
ave_x2=total(x2(igood_2))/npts_2
ave_y2=total(y2(igood_2))/npts_2
dx_of_averages=ave_x2-ave_x1
dy_of_averages=ave_y2-ave_y1   ; default averages

;print, 'MOD_DELTA_NOISY, STRAIGHT AVGS=', DX_OF_AVERAGES, DY_OF_AVERAGES


temp_x_avg=fltarr(npts_1)
temp_y_avg=fltarr(npts_1)
temp_x_sigs=fltarr(npts_1)
temp_y_sigs=fltarr(npts_1)




;;;;;loop in a protected way over all pairs
for jkl=0,npts_1-1 do begin
temp_x_avg(jkl)= total( x2(igood_2)-x1(igood_1(jkl)),/double)/npts_2
temp_y_avg(jkl)= total( y2(igood_2)-y1(igood_1(jkl)),/double)/npts_2
temp_x_sigs(jkl)= total( (x2(igood_2)-x1(igood_1(jkl)))^2,/double)/npts_2
temp_y_sigs(jkl)= total( (y2(igood_2)-y1(igood_1(jkl)))^2,/double)/npts_2
endfor





;;;;;;;;;;;;;;;; now all deltas in sum1, sum2
ave_delta_x=total(temp_x_avg,/double)/npts_1
ave_delta_y=total(temp_y_avg,/double)/npts_1
variance_x =( (total(temp_x_sigs)+ $
          total((temp_x_avg-ave_delta_x)^2,/double))/npts_1)^0.5 
variance_y =( (total(temp_y_sigs)+ $
          total((temp_y_avg-ave_delta_y)^2,/double))/npts_1)^0.5 

dx_averaged= ave_delta_x
dy_averaged= ave_delta_y

;PRINT, 'MOD_DELTA_NOISY, DETAILED AVG:=', DX_AVERAGED, DX_AVERAGED
;PRINT, 'MOD_DELTA_NOISY, DETAILED VAR:=', VARIANCE_X, VARIANCE_Y



end
