pro mod_new_delta_noisy_with_weights, x1,y1, x2, y2, weights2, dx_averaged,dy_averaged, variance_x, variance_y, $
               dx_of_averages,dy_of_averages,$
               ave_x1, ave_y1, ave_x2,ave_y2
;
; purpose take two noisy 2d vectors in and consider all possible deltas between
; the groups and report the average delta and the delta of the respective averages
; as well as the variances on the deltas... intended to be used when comparing
;  ExB drifts with U_perp electrons..........

; Modified to be robust when Scanner points come back with 136,000 entries
;  creating an unduly large check


;
;
;  default load for return
;
fill = 1e10
dx_averaged=-1e31
dy_averaged=-1e31
variance_x=-1e31
variance_y=-1e31
dx_of_averages=-1e31
dy_of_averages=-1e31

igood_1=where(abs(x1) lt  fill and abs(y1) lt fill, npts_1)
igood_2=where(abs(x2) lt  fill and abs(y2) lt fill, npts_2)
if(npts_1*npts_2 eq 0) then return

temp_x_sig2=fltarr(npts_1)
temp_y_sig2=temp_x_sig2
temp_x_avg=fltarr(npts_1)
temp_y_avg=temp_x_avg

ave_x1=total(x1(igood_1))/npts_1
ave_y1=total(y1(igood_1))/npts_1

ave_x2=total(x2(igood_2)*weights2(igood_2))/total(weights2(igood_2))
ave_y2=total(y2(igood_2)*weights2(igood_2))/total(weights2(igood_2))

dx_of_averages=ave_x2-ave_x1    ;<<<<<<almost the correct answer
dy_of_averages=ave_y2-ave_y1    ;<<<<<<almost the correct answer 

;print, 'MOD_NEW_DELTA_NOISY, DIF AVERAGES=', DX_OF_AVERAGES, DY_OF_AVERAGES

weight_total=total(weights2(igood_2))

for jkl=0, npts_1-1 do begin
  delta_x_dummy=x2(igood_2)-x1(igood_1(jkl))
  delta_y_dummy=y2(igood_2)-y1(igood_1(jkl))
  temp_x_avg(jkl)= total( delta_x_dummy*weights2(igood_2),/double)$
                           /weight_total
  temp_y_avg(jkl)= total(delta_y_dummy*weights2(igood_2),/double)$
                           /weight_total
  temp_x_sig2(jkl)= total((delta_x_dummy-$
            temp_x_avg(jkl))^2*weights2(igood_2), /double)$
                 / weight_total
  temp_y_sig2(jkl)= total((delta_y_dummy-$
           temp_y_avg(jkl))^2*weights2(igood_2), /double)$
                           / weight_total
endfor
ave_delta_x=total(temp_x_avg)/npts_1
ave_delta_y=total(temp_y_avg)/npts_1
variance_x=((total(temp_x_sig2)+ total((temp_x_avg-ave_delta_x)^2))/npts_1)^0.5
variance_y=((total(temp_y_sig2)+ total((temp_y_avg-ave_delta_y)^2))/npts_1)^0.5

dx_averaged= ave_delta_x
dy_averaged= ave_delta_y

;PRINT, 'MOD_NEW_DELTA_NOISY, WEIGHTED DETAILED AVG=', DX_AVERAGED, DY_AVERAGED
;PRINT, 'MOD_NEW_DELTA_NOISY, VAR=', VARIANCE_X, VARIANCE_Y


end
