pro new_delta_noisy_with_weights, x1,y1, x2, y2, weights2, dx_averaged,dy_averaged, variance_x, variance_y, $
               dx_of_averages,dy_of_averages,$
               ave_x1, ave_y1, ave_x2,ave_y2
;
; purpose take two noisy 2d vectors in and consider all possible deltas between
; the groups and report the average delta and the delta of the respective averages
; as well as the variances on the deltas... intended to be used when comparing
;  ExB drifts with U_perp electrons..........
;
fill = 1e10
igood_1=where(abs(x1) lt  fill and abs(y1) lt fill, npts_1)
igood_2=where(abs(x2) lt  fill and abs(y2) lt fill, npts_2)
check=npts_1*npts_2
dx_averaged=-1e31
dy_averaged=-1e31
variance_x=-1e31
variance_y=-1e31
dx_of_averages=-1e31
dy_of_averages=-1e31
;
;  default load for return
;
if(check eq 0) then return
ave_x1=total(x1(igood_1))/npts_1
ave_y1=total(y1(igood_1))/npts_1

ave_x2=total(x2(igood_2)*weights2(igood_2))/total(weights2(igood_2))
ave_y2=total(y2(igood_2)*weights2(igood_2))/total(weights2(igood_2))

dx_of_averages=ave_x2-ave_x1
dy_of_averages=ave_y2-ave_y1

x1_dummy=x1(igood_1)
y1_dummy=y1(igood_1)
x2_dummy=x2(igood_2)
y2_dummy=y2(igood_2)
weight_dummy=weights2(igood_2)
for jkl=0, npts_1-1 do begin
  if(jkl eq 0) then begin
            delta_1= [(x2_dummy-x1_dummy(jkl))]
            delta_2= [(y2_dummy-y1_dummy(jkl))]
            weight=[weight_dummy]
            endif
  if(jkl gt 0) then begin
            delta_1=[delta_1, (x2_dummy-x1_dummy(jkl))]
            delta_2=[delta_2, (y2_dummy-y1_dummy(jkl))]
            weight=[weight, weight_dummy]
            endif
endfor
;;;;;;;;;;;;;;;; now all deltas in sum1, sum2
ave_delta_x=total(delta_1*weight)/total(weight)
ave_delta_y=total(delta_2*weight)/total(weight)
variance_x = (total((ave_delta_x-delta_1)^2*weight)/total(weight))^0.5
variance_y = (total((ave_delta_y-delta_2)^2*weight)/total(weight))^0.5

dx_averaged= ave_delta_x
dy_averaged= ave_delta_y
end
