pro rough_b_handler, t_in, phi_angle_54, theta_angle_54, average_phi, guard_phi,average_theta,$
 guard_theta, t_center_out
;
;  Design JDS Dec9, 2001
;
igood=where( phi_angle_54 lt 2*!pi and theta_angle_54 lt !pi and t_in gt 0, npts)
average_phi=-1.0e31
guard_phi=-1.0e31
average_theta=-1.0e31
guard_theta=-1.0e31
t_center_out=-1.0e31
if(npts eq 0) then return
sin_theta= sin(theta_angle_54(igood))
x_unit= sin_theta*cos(phi_angle_54(igood))
y_unit= sin_theta*sin(phi_angle_54(igood))
z_unit= cos(theta_angle_54(igood))

ave_x = total(x_unit)/n_elements(igood)
ave_y= total(y_unit)/n_elements(igood)
ave_z= total(z_unit)/n_elements(igood)

renormalize=(ave_x^2+ave_y^2+ave_z^2)^0.5
ave_x=ave_x/renormalize
ave_y=ave_y/renormalize
ave_z=ave_z/renormalize

phi_out= atan(ave_y,ave_x)/!pi*180
theta_out=acos(ave_z)/!pi*180.

variance = ( total((x_unit-ave_x)^2+(y_unit-ave_y)^2+(z_unit-ave_z)^2,/double)/3/$
             n_elements(igood))^0.5

cone_angle= atan(variance/1.)/!pi*180
average_phi=phi_out
guard_phi=cone_angle
average_theta=theta_out
guard_theta=cone_angle
t_center_out= total(t_in(igood))/n_elements(igood)

end