function auto_correlate, x, period_max=period_max, plot=plot
;+
; NAME: auto_correlate
;
; PURPOSE: find the most likely period of repetition by auto_correlation
;
; CATEGORY:
;
; CALLING SEQUENCE: iperiod= auto_correlate( x )
; 
; INPUTS: X, a cyclically series of numbers
;
; OPTIONAL INPUTS: 
;	
; KEYWORD PARAMETERS: 
;   /plot  show graphic of correlation during the search
;   period_max=i  maximum period to try
;
; OUTPUTS:
;   prints the repetition interval
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;
; PROCEDURE:
;    scan period space from 2 to period_max, looking to maximize the
;    correlation
;
; EXAMPLE:
;    N= 800
;    x= sin( findgen(N)/(N-1) * 4 * 2 * !pi ) + randomn(s,N) / 50
;    plot, x
;    iper= auto_correlate( x )
;    print, iper
;    plot, x(iper:*), x
;
; MODIFICATION HISTORY:
;
;-
  

  if n_elements( period_max ) eq 0 then period_max= n_elements(x)/2

  rchi= replicate( 1e31, period_max+1 ) 
  plot= keyword_set(plot)
  for i=2,period_max do begin      
      test=  abs( x[i:*] - x[0:*] )
      rchi[i]= total( test ) / n_elements(test)
      if plot then begin
          plot, x[i:*], x[0:*], psym=3
          wait, 0.01
      endif
  endfor
;  plot, rchi, max_value=1e30
  t_= min( rchi, imin )
  return, imin
  stop
end
