; block_tool.pro
;
; user-interface for plot_block.  Provides extra buffering
; for plot block, as well as easy previous- and next-block
; access.  
;
; Written:
;    7/31/96  by Jeremy Faden
;

pro block_tool, date, timef, next=next, previous=previous, display=display, $
                _extra=e

common block_buffer, scan_len, species, ienergy, energy, phase, pitch, $
  counts, cdate, ctime, timeinfo

common ui_buffer, blocks, st_date, st_time, en_date, en_time,         $
  max_numblocks, numblocks, index, keywords

max_block_len = 512

if not keyword_set(e) then begin
   if keyword_set(keywords) then e=keywords 
endif else keywords=e

if not keyword_set(max_numblocks) then begin
  max_numblocks=10
  x_= {block, scan_len:0, species:intarr(max_block_len),                      $
              ienergy:intarr(max_block_len), energy:fltarr(max_block_len),    $
              phase:fltarr(max_block_len), counts:intarr(max_block_len,12),   $
              pitch:fltarr(max_block_len,12), cdate:'000000', ctime:'000000', $
              timeinfo:''}
  blocks=replicate( {block}, max_numblocks )
  index=0
endif

if keyword_set(next) then $
   if (index lt numblocks-1) then begin
      index=index+1
      goto, plotdata
   endif else begin
      dir=1
      goto, getdata
   endelse

if keyword_set(previous) then $
   if (index gt 0) then begin
      index=index-1
      goto, plotdata
   endif else begin
      dir=-1
      goto, getdata
   endelse

if (keyword_set(date)) then begin
   dir=0
   goto, getdata
endif else goto, plotdata

getdata:
getnextblock, date, timef, dir

if ( numblocks eq 0 ) then begin
nodata:
  print, 'no data found at ', timef
  if (dir eq 0) then dir=1
  goto, getdata
endif

; place index outside of overlap
if (dir eq -1) then begin 
   index=numblocks
   repeat begin
     index=index-1
     ti=blocks(index).timeinfo
     index_time=strmid(ti,6,2) +strmid(ti,9,2)+ strmid(ti,12,2)
   endrep until ((index_time lt st_time) or (index eq 0))
   if ( (index eq 0) and (index_time ge st_time) ) then numblocks=0
endif else if (dir eq 1) then begin
   index=-1
   repeat begin
     index=index+1
     ti=blocks(index).timeinfo
     index_time=strmid(ti,6,2) +strmid(ti,9,2)+ strmid(ti,12,2)
   endrep until ((index_time gt en_time) or (index eq numblocks))
   if ( (index eq numblocks) and (index_time le en_time) ) then numblocks=0
endif else if (dir eq 0) then    $
   index=0

if ( numblocks eq 0 ) then goto, nodata

ti=blocks(0).timeinfo
st_time=strmid(ti,6,2) +strmid(ti,9,2)+ strmid(ti,12,2)
st_date=strmid(ti,28,2)+strmid(ti,22,2)+strmid(ti,25,2)

ti=blocks(numblocks-1).timeinfo
en_time=strmid(ti,6,2) +strmid(ti,9,2)+ strmid(ti,12,2)
en_date=strmid(ti,28,2)+strmid(ti,22,2)+strmid(ti,25,2)
      

plotdata:
; plot the data by copying the index-th block plot_block's buffer
; and make a call to plot_buffer with the correct arguments.
print, format='("index=",i2,"  numblocks=",i2)', index, numblocks
scan_len=   blocks(index).scan_len
species=    blocks(index).species
ienergy=    blocks(index).ienergy
energy=     blocks(index).energy
phase=      blocks(index).phase
counts=     blocks(index).counts
pitch=      blocks(index).pitch
timeinfo=   blocks(index).timeinfo

plot_block, /buffer, /display, _extra=e

END
