      program main

c extract.F
c
c extracts data from level-zero files.
c data extracted is counts vs. s/c-phase and energy for
c each detector in a given block.
c
c History:
c   7/19/96 written, Jeremy Faden

c  include file is not on include path - Makefile must specify directory
#include 'high_level_structure.hf'
      external read_ddeis_lz     !$pragma C( read_ddeis_lz )
      external library_version   !$pragma C( library_version )
      external dd_angles
      external speed_shell2      
      external ddeis_f

c define read_ddeis modes
#define  INIT 0
#define  NEXT 1
#define  PSI  16

      record /time_def/ timea, timeb
      record /ddeis_data_output/ ddeis_data
      record /angles_data/ ddeis_angles      ! needed to trick version check

      integer*4 status_block, istat, mjf
      character*80  path, mask_path
      character*10  library
      character*6   date
      character*6   time
      character*30  timedatestr
      integer*4     read_ddeis_lz
      character*4   lenarg
      logical       oneblock
      integer       unit

      ddeis_angles.version=version           ! trick version check

      call set_time_lz( timea, timeb, path, mask_path )

      ipos= index(path,'lz_hyd') + 9
      date= path(ipos:ipos+5)

      call getarg(3,lenarg)
      if (lenarg.eq.'0') then
         oneblock=.true.
         unit=10
      else
         oneblock=.false.
         unit=10
      endif

      write(time,'(i2.2i2.2i2.2)') timea.hour, timea.min, timea.second
      open(unit, file=date//'.'//time//'.dat')

      istat= library_version(library)
      istat= read_ddeis_lz( INIT+PSI, path, timea, timeb, ddeis_data,
     $     status_block, mjf, mask_path )

      if (( status_block.ne.0 ).or.( istat.ne.1 )) stop
      write(unit,'(a10,i3)') library, ddeis_data.glint_mask_version


c read data loop
      do while ( ( status_block.eq.0 ).and.( istat.eq.1 ) )
         call dd_angles( ddeis_data, ddeis_angles )

         write( unit,'(i4)' ) ddeis_data.scan_length
         call maketimedatestr( timedatestr, ddeis_data.ddcyctim )
         write( unit,98 ) timedatestr, ddeis_data.psi_status, 
     $        ddeis_data.mode
         do 10 i= 1, ddeis_data.scan_length
            write(unit,100) ddeis_data.species(i), 
     $           ddeis_data.energy_index(i),
     $           ddeis_data.energy(i),
     $           ddeis_data.phase(i)
            do 12 j=1,12
               if (ddeis_data.glint_mask(j,i).ne.0) then
                  write(unit,102) ddeis_data.counts(j,i)
               else
                  write(unit,102) -99
               endif	
 12         continue
            do 14 j=1,12
               write(unit,104) ddeis_angles.alpha(j,i)
 14         continue
            write(unit,*)	
 10      continue
         
         istat= read_ddeis_lz( NEXT, path, timea, timeb, ddeis_data,
     $        status_block, mjf, mask_path )
         if (oneblock) istat=0      ! cause fail to exit loop
      enddo
c end read data loop
      if (unit.eq.10) close(10)

 98   format(a30,'  PSI= ',i2,'  MODE=',i2)
 100  format(i3,i4,f8.1,f8.4,$)
 102  format(i6,$)
 104  format(f8.4,$)
      end

      
      subroutine maketimedatestr( str, time_date )
#include 'high_level_structure.hf'

      character*80 str
      record /time_def/ time_date

      write( str,99 ) time_date.hour,
     $        time_date.min,
     $        time_date.second,
     $        time_date.month,
     $        time_date.day,
     $        time_date.year
 99   format('Time: ',i2,':',i2,':',i2,'  Date: ',i2,'/',i2,'/',i2)

      if (str(7:7).eq.' ')   str(7:7)='0'
      if (str(10:10).eq.' ') str(10:10)='0'
      if (str(13:13).eq.' ') str(13:13)='0'
      if (str(23:23).eq.' ') str(23:23)='0'
      if (str(26:26).eq.' ') str(26:26)='0'
      if (str(29:29).eq.' ') str(29:29)='0'
 
      return
      end

