c
c     Set the starting and ending times for access.  
c     Set the path to the hydra lz file.
c
c     Modified:
c        7/8/96 by Jeremy Faden
c            date is read from command line.  usage: $0 YYMMDD HHMM N
c        7/29/96 by jbf
c            N is the number of minutes to read, 0 = one block
c

      subroutine set_time_lz(time1, time2, path, mask_path)
#include 'high_level_structure.hf'
      record /time_def/ time1, time2
      character*80 path,mask_path
      character*6 date
      character*8 time
      character*4,len
      character*20 prgname
      integer imon,iday,iyear
      
      if ( iargc().eq.3 ) then
         call getarg( 1,date ) 
	 call getarg( 2,time )
         call getarg( 3,len )
      else
         call getarg( 0,prgname )
         print *, 'Usage: ', prgname, ' <YYMMDD> <HH:MM:SS> <len>'
         print *, '  <len>=0 reads one block to std out'
	 stop
      endif

      read( date(1:2),'(i2)' ) iyear
      read( date(3:4),'(i2)' ) imon
      read( date(5:6),'(i2)' ) iday
      read( time(1:2),'(i2)' ) ihour
      read( time(4:5),'(i2)' ) imin
      read( time(7:8),'(i2)' ) isec
      read( len, '(i2)' ) ilen
      if (ilen.eq.0) ilen=1       ! one block read    

      time1.year = iyear
      time1.month = imon
      time1.day =iday
      time1.hour = ihour
      time1.min = imin
      time1.second = isec
      time1.total_seconds = 0
      time1.total_time = 0

      time2.year = iyear
      time2.month= imon
      time2.day =iday
      time2.hour = ihour
      time2.min = imin+ilen
      time2.second = isec
      time2.total_seconds = 0
      time2.total_time = 0

c     Near Real Time file:
      if (date(1:6).lt.'960418') then
         path = '/opt/hydra/lz0/po_lz_hyd_19'//date(1:6)//'_v01.dat'
         mask_path = '/opt/hydra/lz0/mask/beta/'
      elseif (date(1:6).lt.'960516') then
         path = '/opt/hydra/lz1/po_lz_hyd_19'//date(1:6)//'_v01.dat'
         mask_path = '/opt/hydra/lz1/mask/beta/'
      elseif (date(1:6).lt.'960709') then
         path = '/opt/hydra/lz2/po_lz_hyd_19'//date(1:6)//'_v01.dat'
         mask_path = '/opt/hydra/lz2/mask/beta/'
      else
         path = '/opt/hydra/lz3/po_lz_hyd_19'//date(1:6)//'_v01.dat'
         mask_path = '/opt/hydra/lz3/mask/beta/'
      endif

      return
      end


