pro bt_load_colors
   
   common blocktool_colors, ncolors, background, foreground, $
    black, white, gray, yellow, blue, red, color_r, color_g, color_b

;   loadct_hydra, 18             ; gsfc
   loadct, 13                   ; idl rainbow

   multi,!d.n_colors/float(ncolors) ; 0 thru n_colors-1 is color bar
   tvlct, color_r, color_g, color_b, /get
   
   black = 0
   white = ncolors+0
   gray = ncolors+1
   yellow = ncolors+2
   blue = ncolors+3
   red = ncolors+4
   background = ncolors+5
   foreground = ncolors+6
   
   !p.background = background

   pcl = 0
   ps = 0

   if (pcl EQ 1 OR ps EQ 1) then begin
      color_r(background) = 255
      color_g(background) = 255
      color_b(background) = 255
      
      color_r(foreground) = 0
      color_g(foreground) = 0
      color_b(foreground) = 0
      
      color_r(blue) = 0
      color_g(blue) = 0
      color_b(blue) = 255
      
      orbit1 = blue
      orbit2 = red

   endif else begin
      color_r(background) = 0
      color_g(background) = 0
      color_b(background) = 0
      
      color_r(foreground) = 255
      color_g(foreground) = 255
      color_b(foreground) = 255
      
      color_r(blue) = 91
      color_g(blue) = 240
      color_b(blue) = 255

   endelse
   
   color_r(black) = 0
   color_g(black) = 0
   color_b(black) = 0
   
   color_r(gray) = 140
   color_g(gray) = 140
   color_b(gray) = 140
   
   color_r(white) = 255
   color_g(white) = 255
   color_b(white) = 255
   
   color_r(red) = 255
   color_g(red) = 0
   color_b(red) = 0

   color_r(yellow) = 255
   color_g(yellow) = 255
   color_b(yellow) = 0
      
   tvlct, color_r, color_g, color_b
   
   return
end






