#!/bin/csh
#set verbose
#set echo
#
# make_gif_html.sh
#
# produces the html index for a bunch of gifs.
#

set nsref = http://www-st.physics.uiowa.edu/archive/plots/ddeis/special
#set nsref = file:/home/jbf/work/beam/gifs
set nsdir = /net/hydra/export/data1/ns-home/docs/`echo $nsref | cut -c33-`
#set nsdir = /home/jbf/work/beam/gifs

set icon_dir = $nsref/icons

set index_file = index.html

set gif_head_file = $nsdir/html_parts/gif_head.htmlfrag
set gif_tail_file = $nsdir/html_parts/gif_tail.htmlfrag

set today = `date`
set today_month = `echo $today | awk '{print $2}' -`
set today_day = `echo $today | awk '{print $3}' -`
set today_year = `echo $today | awk '{print $6}' -`
set today[1] = $today_month
set today[2] = $today_day,
set today[3] = $today_year
set today[4] = ""
set today[5] = ""
set today[6] = ""

echo 's/Last Revised: ... .., ..../Last Revised: '$today'/' > $nsdir/dateline.sed
cp $gif_tail_file $gif_tail_file.tmp
cat $gif_tail_file.tmp | sed -f $nsdir/dateline.sed > $gif_tail_file
rm $nsdir/dateline.sed
rm $gif_tail_file.tmp

set files = `cat $nsdir/create.list`

set count = 0
foreach i ($files)
   @ count = $count + 1
   set file  = $i:t    
   set file = $file:r
   set fn   = $i:t     # no path
   set year  = `echo $fn | awk '{print substr($1,1,2)}' `
   set month = `echo $fn | awk '{print substr($1,3,2)}' `
   set day   = `echo $fn | awk '{print substr($1,5,2)}' `
   set datestr = $month/$day/$year

   echo 'Adding ' $file
   set gif_html_file = $file.html

   set species = `echo $file | cut -c14`
   set datetime = `echo $file | cut -c-13`

   cat $gif_head_file > $nsdir/$gif_html_file

# add previous button
   if ($count > 2) then
      @ prev_count = $count - 2
      set prev = $files[$prev_count]:t
      set prev = $prev:r

      echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
      echo '<a href='$nsref/$prev.html'> <img src='$icon_dir'/leftarrow.gif> </a>' >> $nsdir/$gif_html_file
   else
      echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
      echo '<a href='$nsref/$gif_html_file'> <img src='$icon_dir'/grey_leftarrow.gif> </a>' >> $nsdir/$gif_html_file
   endif

#add next button
   if ($count < `expr $#files - 1`) then
      @ next_count = $count + 2
      set next = $files[$next_count]:t
      set next = $next:r

      echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
      echo '<a href='$nsref/$next.html'> <img src='$icon_dir'/rightarrow.gif> </a>' >> $nsdir/$gif_html_file
   else
      echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
      echo '<a href='$nsref/$gif_html_file'> <img src='$icon_dir'/grey_rightarrow.gif> </a>' >> $nsdir/$gif_html_file

   endif


# add other species button
   if ( $species == "I" ) then
      echo "<a href=$nsref/${datetime}E.html> <img src="$icon_dir"/species.gif> </a>" >> $nsdir/$gif_html_file
   else
      echo "<a href=$nsref/${datetime}I.html> <img src="$icon_dir"/species.gif> </a>" >> $nsdir/$gif_html_file
   endif


# add choose button
   echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
   echo '<a href='$nsref/$index_file'> <img src='$icon_dir'/choose.gif </a>' >> $nsdir/$gif_html_file


# add spectragram zoom button
   set specname = `echo $datetime | cut -c1-4`/`echo $datetime | cut -c1-6`.html
   echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
   echo '<a href='$nsref'/960713_12_rh_4_v01zb.gif> <img src='$icon_dir'/spectragram_zoom.gif </a>' >> $nsdir/$gif_html_file

# add spectragram button
   set specname = `echo $datetime | cut -c1-4`/`echo $datetime | cut -c1-6`.html
   echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
   echo '<a href=http://www-st.physics.uiowa.edu/archive/plots/ddeis/spectra/'$specname'> <img src='$icon_dir'/spectragram.gif </a>' >> $nsdir/$gif_html_file

# add data page button
   echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
   echo '<a href=http://www-st.physics.uiowa.edu/archive/plots.html> <img src='$icon_dir'/data_page.gif </a>' >> $nsdir/$gif_html_file


# add the plot
   echo '<p ALIGN=LEFT>' >> $nsdir/$gif_html_file
   echo '<img src='$nsref/$file.gif'></p>' >> $nsdir/$gif_html_file

   cat $gif_tail_file >> $nsdir/$gif_html_file
end

exit

