#!/bin/csh
#set verbose
#set echo
#
# make_html.sh
#
# produces the html index for a bunch of gifs.
#

set nsref = http://www-st.physics.uiowa.edu/archive/plots/ddeis/special
#set nsref = file:/home/jbf/work/beam/gifs
set nsdir = /net/hydra/export/data1/ns-home/docs/`echo $nsref | cut -c33-`
#set nsdir = /home/jbf/work/beam/gifs

set icon_dir = $nsref/icons

set index_head_file = $nsdir/html_parts/index_head.htmlfrag
set index_tail_file = $nsdir/html_parts/index_tail.htmlfrag
set index_body_file = $nsdir/html_parts/index_body.htmlfrag
set index_file = index.html

set gif_head_file = $nsdir/html_parts/gif_head.htmlfrag
set gif_tail_file = $nsdir/html_parts/gif_tail.htmlfrag

# set initialize to 1 if index has not been created once before.
if ( -f $index_body_file ) then
   set initialize = 0
else
   set initialize = 1
endif

set today = `date`
set today_month = `echo $today | awk '{print $2}' -`
set today_day = `echo $today | awk '{print $3}' -`
set today_year = `echo $today | awk '{print $6}' -`
set today[1] = $today_month
set today[2] = $today_day,
set today[3] = $today_year
set today[4] = ""
set today[5] = ""
set today[6] = ""

echo 's/Last Revised: ... .., ..../Last Revised: '$today'/' > $nsdir/dateline.sed
cp $index_tail_file $index_tail_file.tmp
cat $index_tail_file.tmp | sed -f $nsdir/dateline.sed > $index_tail_file
cp $gif_tail_file $gif_tail_file.tmp
cat $gif_tail_file.tmp | sed -f $nsdir/dateline.sed > $gif_tail_file
rm $nsdir/dateline.sed
rm $index_tail_file.tmp
rm $gif_tail_file.tmp

set files = `cat $nsref/create.list`

if ( $initialize == 1 ) then
  #remove last line of $index_body_file, we always need to redo last one.
  set len = `wc -l $index_body_file | awk '{print $1}'`
  cat $index_body_file | head -`expr $len - 1` > $index_body_file.TEMP
  mv $index_body_file.TEMP $index_body_file
endif

set count = 0
foreach i ($files)
   @ count = $count + 1
   set file  = $i:t    
   set file = $file:r
   set fn   = $i:t     # no path
   set year  = `echo $fn | awk '{print substr($1,1,2)}' `
   set month = `echo $fn | awk '{print substr($1,3,2)}' `
   set day   = `echo $fn | awk '{print substr($1,5,2)}' `
   set datestr = $month/$day/$year

   if ($initialize == 0) then
      set isthere = `grep -c $file $index_body_file`
   else
      set isthere = 0
   endif

   if ($isthere == 0) then
      echo 'Adding ' $file
      set gif_html_file = $file.html

      set species = `echo $file | cut -c14`
      set datetime = `echo $file | cut -c-13`

      if ( $species == "I" ) then
         echo '<li><a href='$nsref/$gif_html_file'>'$datetime'</a>' >> $index_body_file
      endif

      cat $gif_head_file > $nsdir/$gif_html_file

# add previous button
      if ($count > 2) then
         @ prev_count = $count - 2
         set prev = $files[$prev_count]:t
         set prev = $prev:r

         echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
         echo '<a href='$nsref/$prev.html'> <img src='$icon_dir'/leftarrow.gif> </a>' >> $nsdir/$gif_html_file
      endif

#add next button
      if ($count < `expr $#files - 1`) then
         @ next_count = $count + 2
         set next = $files[$next_count]:t
         set next = $next:r

         echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
         echo '<a href='$nsref/$next.html'> <img src='$icon_dir'/rightarrow.gif> </a>' >> $nsdir/$gif_html_file
      endif


# add other species button
      if ( $species == "I" ) then
         echo "<a href=$nsref/${datetime}E.html> <img src="$icon_dir"/species.gif> </a>" >> $nsdir/$gif_html_file
      else
         echo "<a href=$nsref/${datetime}I.html> <img src="$icon_dir"/species.gif> </a>" >> $nsdir/$gif_html_file
      endif


# add choose button
      echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
      echo '<a href='$nsref/$index_file'> <img src='$icon_dir'/choose.gif </a>' >> $nsdir/$gif_html_file


# add spectragram zoom button
      set specname = `echo $datetime | cut -c1-4`/`echo $datetime | cut -c1-6`.html
      echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
      echo '<a href='$nsref'/960713_rh_4_v01zb.gif> <img src='$icon_dir'/spectragram_zoom.gif </a>' >> $nsdir/$gif_html_file

# add spectragram button
      set specname = `echo $datetime | cut -c1-4`/`echo $datetime | cut -c1-6`.html
      echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
      echo '<a href=http://www-st.physics.uiowa.edu/archive/plots/ddeis/spectra/'$specname> <img src='$icon_dir'/spectragram.gif </a>' >> $nsdir/$gif_html_file

# add data page button
      echo '<ALIGN=RIGHT>' >> $nsdir/$gif_html_file
      echo '<a href=http://www-st.physics.uiowa.edu/archive/plots.html> <img src='$icon_dir'/data_page.gif </a>' >> $nsdir/$gif_html_file


# add the plot
      echo '<p ALIGN=LEFT>' >> $nsdir/$gif_html_file
      echo '<img src='$nsref/$file.gif'></p>' >> $nsdir/$gif_html_file

      cat $gif_tail_file >> $nsdir/$gif_html_file
   else
      echo 'Skipping '$file
      if ($count == 1) then
#         set first_date = $date_string
      endif
      if ($count == $#files) then
#         set last_date = $date_string
      endif
   endif
end

cat $index_head_file         > $nsdir/$index_file
cat $index_body_file | sort >> $nsdir/$index_file
cat $index_tail_file        >> $nsdir/$index_file

exit

