#!/bin/csh
#set verbose
#set echo
#
# make_html.sh
#
# produces the html index for a bunch of gifs.
#

set nsref = http://www-st.physics.uiowa.edu/archive/plots/ddeis/special
#set nsref = file:/home/jbf/work/beam/gifs
set nsdir = /net/hydra/export/data1/ns-home/docs/`echo $nsref | cut -c33-`
#set nsdir = /home/jbf/work/beam/gifs

set icon_dir = $nsref/icons

set index_head_file = $nsdir/html_parts/index_head.htmlfrag
set index_tail_file = $nsdir/html_parts/index_tail.htmlfrag
set index_body_file = $nsdir/html_parts/index_body.htmlfrag
set index_file = index.html

# set initialize to 1 if index has not been created once before.
#if ( -f $index_body_file ) then
#   set initialize = 0
#else
#   set initialize = 1
#endif

set today = `date`
set today_month = `echo $today | awk '{print $2}' -`
set today_day = `echo $today | awk '{print $3}' -`
set today_year = `echo $today | awk '{print $6}' -`
set today[1] = $today_month
set today[2] = $today_day,
set today[3] = $today_year
set today[4] = ""
set today[5] = ""
set today[6] = ""

echo 's/Last Revised: ... .., ..../Last Revised: '$today'/' > $nsdir/dateline.sed
cp $index_tail_file $index_tail_file.tmp
cat $index_tail_file.tmp | sed -f $nsdir/dateline.sed > $index_tail_file
rm $nsdir/dateline.sed
rm $index_tail_file.tmp

set files = `cat $nsdir/index.list`

foreach i ($files)
   set file  = $i:t    
   set file = $file:r
   set fn   = $i:t     # no path
   set year  = `echo $fn | awk '{print substr($1,1,2)}' `
   set month = `echo $fn | awk '{print substr($1,3,2)}' `
   set day   = `echo $fn | awk '{print substr($1,5,2)}' `
   set datestr = $month/$day/$year

#   if ($initialize == 0) then
#      set isthere = `grep -c $file $index_body_file`
#   else
#      set isthere = 0
#   endif

set isthere = 0
   if ($isthere == 0) then
      echo 'Adding ' $file
      set gif_html_file = $file.html

      set datetime = `echo $file | cut -c-13`

      echo '<li><a href='$nsref/$gif_html_file'>'$datetime'</a>' >> $index_body_file

   else
      echo 'Skipping '$file
#      if ($count == 1) then
#         set first_date = $date_string
      endif
#      if ($count == $#files) then
#         set last_date = $date_string
      endif
   endif
end


cat $index_head_file         > $nsdir/$index_file
cat $index_body_file | sort >> $nsdir/$index_file
cat $index_tail_file        >> $nsdir/$index_file

exit

