; getnextblock.pro
;
; read the "next" block using the extract program.  getnextblock_static
; contains the time and date of the last block read.  The argument "dir"
; whether to go ahead or back in time.  The data is read and then put
; in to the blocks buffer.

pro getnextblock, date, timef, dir, datamode

common blocktool_ui_buffer, blocks, st_date, st_time, en_date, en_time,         $
  max_numblocks, numblocks, index, keywords
common blocktool_getnextblock_static, read_date, read_time

if (dir eq 0) then begin
   read_date= date
   read_time= strmid(timef,0,2) + strmid(timef,3,2) + strmid(timef,6,2)
endif

hour=fix(strmid(read_time,0,2))
min= fix(strmid(read_time,2,2))
sec= fix(strmid(read_time,4,2))

tsec= sec+dir*100
sec=  tsec mod 60.0
if (sec lt 0.0) then begin
  min=min-1
  sec=sec+60.0
endif

tmin= min+ fix(tsec) / 60
min=  tmin mod 60.0
if (min lt 0.0) then begin
  hour=hour-1
  min=min+60.0
endif
hour= hour+ tmin / 60

if (hour lt 0.0) then begin
  print, "Can't cross midnight--not implemented"
  hour=0.0
endif

timef=string(fix(hour),format='(i2)') + ':' +             $
      string(fix(min), format='(i2)')  + ':' +            $ 
      string(fix(sec), format='(i2)')
if strmid(timef,0,1) eq ' ' then strput, timef, '0', 0
if strmid(timef,3,1) eq ' ' then strput, timef, '0', 3
if strmid(timef,6,1) eq ' ' then strput, timef, '0', 6

date=read_date

read_time= strmid(timef,0,2) + strmid(timef,3,2) + strmid(timef,6,2)
;read_date= date

openfile: 
print, 'extracting data... '+date+' '+timef
spawn, "/home/jbf/work/idl_util/block/extract "+date+" "+timef+ $
  " 2 "+strtrim(datamode,2)
unit=10
time=strmid(timef,0,2)+strmid(timef,3,2)+strmid(timef,6,2); remove colons
fname= date+'.'+time+'.dat'
openr, unit, fname

; read the data file, filling the buffer.
libmask=string(30)
if (not eof(unit)) then  $
  readf, unit, libmask   $           ; read in library and mask
else begin
  close, unit
  numblocks=0
  goto, end_
endelse
  
readdata:   
 ; read one block from the data file 
  j=0;
readblockloop:
  readf, unit, scan_len
  if (scan_len gt 512) then stop, 'scan length greater than 512.'
  blocks(j).scan_len=scan_len
  timeinfo='timeinfo is a string'
  readf, unit, timeinfo
  blocks(j).timeinfo=timeinfo
  species=intarr(scan_len)
  ienergy=intarr(scan_len)
  energy=fltarr(scan_len)
  phase= fltarr(scan_len)
  counts= fltarr(scan_len,12)
  pitch= fltarr(scan_len,12)
  tcounts= intarr(12)
  tpitch= fltarr(12)
  radtodeg= 180.0/acos(-1.0)
  for i=0,scan_len-1 do begin
     readf, unit, tspecies, tienergy, tenergy, tphase, tcounts, tpitch
     blocks(j).species(i)=tspecies
     blocks(j).ienergy(i)=abs(tienergy)
     blocks(j).energy(i)=tenergy
     blocks(j).phase(i)=tphase*radtodeg
     blocks(j).counts(i,*)=tcounts
     blocks(j).pitch(i,*)=tpitch*radtodeg
  endfor

  j=j+1
if (not eof(unit)) and (j lt max_numblocks) then goto, readblockloop

close, unit
spawn, 'rm '+fname 

numblocks=j

end_:
print, format='("found ",i2," blocks.")', numblocks

END

