;+
; NAME: cdf_search
;
; PURPOSE: find cdf's where a condition is true
;
; CATEGORY:
;
; CALLING SEQUENCE: 
;   cdf_search, filewild, variable, condition
; 
; INPUTS:
;    filewild  string filename wild card files to search
;    variable  string zvar name to check 
;    condition string condition to evaluate
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;    prints a list of files matching.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;
; PROCEDURE:
;
; EXAMPLE:
;   cdf_search, '/opt/hydra/ppal1_01/*_hyd_ppa_v*.cdf', 'BLOCK_MODE', 'gt 1'
;
; MODIFICATION HISTORY:
;   written, jbf, Univ of Iowa, September 9, 2002.
;-
  
pro cdf_search, wildcard, variable, condition
  files= ['']
  f= findfile(wildcard, count=count)
  if count eq 0 then begin
      print, 'No files match wildcard: '+wildcard
      return
  endif
  for ifile= 0,count-1 do begin
      print, format='(a,$)', '.'
      cdf= cdf_open(f[ifile])
      hyd_cdf_varget, cdf, variable, data, rec_count=cdf_nrec(cdf,variable)
      cdf_close, cdf
      exestr= 'x= where( data ' + condition + ', count )'
      r= execute(exestr)
      if r ne 1 then begin
          print, 'error in condition string:' +condition
          print, '  (I tried to evaluate: '+exestr+')'
      endif
      if count gt 0 then begin
          files= [ files, f[ifile] ]
      endif
  endfor
  
  if n_elements(files) eq 1 then begin
      print, 'No files have condition true: '+condition
      return
  endif

  files= files[1:*]
  for i=0,n_elements(files)-1 do begin
      print, files[i]
  endfor

end

