pro check_footprints, dbfile, not_okay
; I/O:
; dfile is a cdf id or the name of a database file
; notokay is an array of the names of the fields that are not up to date.

  if (size(dbfile))(1) eq 3 then begin
      CDFopen=0
      CDF=dbfile 
  endif else begin
      CDFopen=1
      CDF= cdf_open( dbfile )
  endelse

  cdfinfo= cdf_inquire( CDF )
  nzvars= cdfinfo.nzvars

; OKAY tells whether each field is up-to-date or not.
; it is indexed by zvariable number.
  OKAY= intarr( nzvars )        ; 0=not okay, 1=okay, 99=unknown
  OKAY(*)= 99

; get all the variable names and their dependencies and their current
                                ; version numbers.
  zvarnames=strarr(nzvars)      
  zvardepend=strarr(nzvars)
  zvarvers=fltarr(nzvars)
  for izvar= 0, nzvars-1 do begin
      zvarinfo= cdf_varinq( CDF, izvar, /zvar )          
      zvarnames(izvar)= zvarinfo.name
      cdf_attget, CDF, 'FOOTPRINT', izvar, depend, /zvar
      zvardepend(izvar)= depend
      cdf_attget, CDF, 'CURRENT_VERSION', izvar, vers, /zvar
      if (size(vers))(1) eq 4 then zvarvers(izvar)= vers else zvarvers(izvar)= 999.0 ; some value
  endfor

; loop over the OKAY array until all the fields have been resolved.
  r= where( OKAY eq 99, n_unknown )
  while( n_unknown gt 0 ) do begin
      for izvar= 0, nzvars-1 do begin
          if OKAY(izvar) eq 99 then begin
              if zvardepend(izvar) eq ' ' then OKAY(izvar)=1 else begin
                  childs= str_sep( zvardepend(izvar), ',' )
                  nchild= n_elements( childs )
                  unkn=0
                  notokay=0
                  for ichild=0, nchild-1 do begin
                      r= str_sep(childs(ichild),'=')
                      childname= strtrim(r(0),2)
                      childver= float(r(1))
                      r= where( zvarnames eq childname )
                      if r(0) ne -1 then childznum= r(0) else begin
                          print, 'field dependence not found: '+childname
                          stop
                      endelse       
                      if OKAY(childznum) eq 99 then begin
                          unkn=1 
                      endif else if zvarvers(childznum) gt childver then begin
                          print, zvarnames(izvar)+' '+childname, $
                            ' found:', zvarvers(childznum), $
                            ' hoping for:', childver
                          notokay=1 
                      endif else if OKAY(childznum) eq 0 then begin
                          print, zvarnames(izvar)+' is not okay because ' +$
                            childname+' is not okay.'
                          notokay=1
                      endif
                  endfor
                  if (notokay) then OKAY(izvar)=0 $
                  else if (unkn) then OKAY(izvar)=99 $
                  else OKAY(izvar)=1
              endelse
          endif          
      endfor
      r= where( OKAY eq 99, n_unknown )
  endwhile

  r=where( OKAY eq 0 )          ; not okay
  if r(0) ne -1 then not_okay=zvarnames(r) else not_okay=[' ']

  if (CDFopen) then CDF_close, CDF
end

