pro cleanup, fname

    print, '############################'
    print, '## Modifying database '+fname
    print, '############################'
    CDF= cdf_open( fname )
    cdfinfo= cdf_inquire( CDF )
    nzvars= cdfinfo.nzvars

; loop through the zvars
    zvarnames=strarr(nzvars)      
    for izvar= 0, nzvars-1 do begin        
        zvarinfo= cdf_varinq( CDF, izvar, /zvar )          
        cdf_attget, CDF, 'VALIDMAX', izvar, vers, /zvar
        cdf_attput, CDF, 'CURRENT_VERSION', izvar, vers, /zvar
        cdf_attput, CDF, 'FOOTPRINT', izvar, ' ', /zvar
    endfor
    cdf_close, CDF
end
