function contour_follow, p0=p0, function_name=call_func, scale=scale, $
                         stopping_points= stopping_points, $
                         oplot=oplot
;+
; NAME: contour_follow
;
; PURPOSE: follow a contour of any function of two parameters.
;
; CATEGORY:
;
; CALLING SEQUENCE: contour= contour_follow( p0=fltarr(2), $
;                                            function_name='', $
;                                            scale= 1.0 )
; 
; INPUTS: 
;   p0=fltarr(2)    the starting point, contour level is function(p0)
;   function_name=''  the name of the function to call.  Function must
;                     take fltarr(2) as input.
;   scale=1.0       the size of the steps in the function space.
;
; KEYWORD PARAMETERS:
;   stopping_points=fltarr(*,2)   if contour comes within 0.5 scale of
;                                 this point, then stop.  The starting
;                                 point is always a stopping point.
;
; OUTPUTS:
;   returns fltarr(*,2), the contour.
;
; RESTRICTIONS:
;   
; PROCEDURE:
;   follow function with a triangle, by flipping the triangle over the
;     edge that the contour exits.
;
; EXAMPLE:
;
; MODIFICATION HISTORY:
;   written, March 23, 2001, jbf, University of Iowa
;-

  oplot= keyword_set( oplot )

  starting_point= p0

  if n_elements( stopping_points ) eq 0 then begin
      stopping_points= transpose( starting_point )
  endif else begin
      stopping_points= [ transpose( starting_point ), stopping_points ]
  endelse

  level= call_function( call_func, p0 )

  contour= fltarr(100,2)

  v0= [0,1.]
  v1= [-sqrt(3)/2, -0.5]
  v2= [ sqrt(3)/2, -0.5]
  flip= 1

  t0= call_function( call_func, p0+v0*scale )
  t1= call_function( call_func, p0+v1*scale )
  t2= call_function( call_func, p0+v2*scale )
  
  idx= 0
  not_done=1

  while not_done do begin

;      oplot, p0[0]+ [v1[0],v0[0],v2[0]]*scale, $
;         p0[1]+ [v1[1],v0[1],v2[1]]*scale, color=!cs.grey
      
      if (t0-level)*(level-t2) ge 0. then begin
          
          alpha= (level-t2)/(t0-t2)
          contour(idx,*)= p0 + scale * ( (alpha) * v0 + (1-alpha) * v2 )
          
          p0= p0 - scale * v1 * 1

          v1= -v1
          v2_= v2
          v2= -v0          
          v0= -v2_

          t1= t0
          v1_= v1
          v1= v0
          v0= v1_

          t0= call_function( call_func, p0+v0*scale )

      endif else if (t0-level)*(level-t1) ge 0. then begin

          alpha= (level-t1)/(t0-t1)
          contour(idx,*)= p0 + scale * ( (alpha) * v0 + (1-alpha) * v1 )

          p0= p0 - scale * v2 * 1

          v2= -v2
          v1_= v1
          v1= -v0          
          v0= -v1_

          t2= t0
          v2_= v2
          v2= v0
          v0= v2_

          t0= call_function( call_func, p0+v0*scale )

      endif else begin
          stop, 'lost the contour -- this shouldn''t happen!!!'

      endelse

      if oplot then begin
          oplot, [ contour(idx,0) ], [ contour(idx,1) ], psym=3
      endif

      idx= idx+1
      if idx ge n_elements(contour)/2 then begin
          contour= [ contour, fltarr(100,2) ]
      endif

      r= where( (p0[0]-stopping_points[*,0])^2 + $
                (p0[1]-stopping_points[*,1])^2 lt (scale*0.5)^2 )
      if r(0) ne -1 then not_done=0

  endwhile  

  contour= contour[ 0:(idx-1),* ]

  return, contour

end

