pro hydra_digiplot, X,Y,Z, _extra=plot_par, format=format

  if n_params() eq 0 then begin
      print, 'USAGE:                                                    '    
      print, 'pro hydra_digiplot, X, Y, Z,'
      print, '          _extra=plot_par '
      return
  endif
  
  if not keyword_set( format ) then format='(i9)'
  
  plot, X, Y, /nodata, _extra=plot_par
  
  for i=0, n_elements(Z)-1 do begin
      str= strtrim( string( Z(i), format=format ),2 )
      xyouts, X(i), Y(i), str
  endfor

  return
end
