pro dump_to_gif, filename, print=print, hardcopy=hc
;+
; NAME: dump_to_gif
;
;
;
; PURPOSE: writes current display to gif file
;
;
;
; CATEGORY: utility
;
;
;
; CALLING SEQUENCE: dump_to_gif, [filename]
;
;
; 
; OPTIONAL INPUTS:  
;     filename   explicitly specify output filename,
;                otherwise "idl_dump.gif" is used.
;
;
;	
; KEYWORD PARAMETERS:  
;     /print     exchange white and black colors, which is more ideal
;                for printing the gif image.  (Use "printgif" to print)
;     /hardcopy  like /print, except that spawn is issued as well.
;
; RESTRICTIONS:
;     display assumed to be 'X' or 'WIN'
;
;
; PROCEDURE:
;     tvlct the color table, tvrd the image.
;     if /print:
;       use get_color_index() to get the indeces of black and white colors
;       set black cells to white, and white cells to black.  
;
; EXAMPLE:
;     dump_to_gif, 'show_this_to_jack.gif'
;
;
; MODIFICATION HISTORY:
;     written, 11-18-98, jbf
;-

   if n_elements(filename) eq 0 then filename='./idl_dump.gif'
   hc= keyword_set(hc)
   if hc then print=1
   print=keyword_set(print)

   tvlct, /get, red,green,blue
   d= tvrd()
   if print then begin
       rblack= where(d eq get_color_index('black'))
       rwhite= where(d eq get_color_index('white'))
       if rblack(0) ne -1 then d(rblack)= get_color_index('white')
       if rwhite(0) ne -1 then d(rwhite)= get_color_index('black')
   endif
   write_gif, filename, d, red, green, blue
   
   if hc then spawn, 'printgif '+filename
end


