pro err_surface, Z, dZ_in, x, y, _extra=e, psym=psym, shade=shade, ax=ax
   if n_params() eq 0 then begin
       doc_library, 'err_surface'
       return
   endif
   if n_elements(psym) eq 0 then psym=0
   
   if n_elements(ax) eq 0 then ax=30

   if ax lt 0 then dz= -dz_in else dz= dz_in

   s= size(Z)
   if n_elements(x) eq 0 then x=lindgen(s(1))
   if n_elements(y) eq 0 then y=lindgen(s(2))

   if keyword_set( shade ) then begin
       exestr= 'shade_surf, Z, x, y, ax=ax, _extra=e, /save'
   endif else begin
       exestr= 'surface, Z, x, y, ax=ax, _extra=e, /save'
   endelse

   r= execute( exestr+', /nodata' ) ; plot the surface

   for i=0,n_elements(x)-1 do begin ; plot the lower points
       for j=0,n_elements(y)-1 do begin
           plots, /t3d, [ x(i) ], [ y(j) ], $
             [ z(i,j)-dZ(i,j) ], psym=psym
       endfor
   endfor
   
   r= execute( exestr+', /noerase' ) ; plot the surface

   for i=0,n_elements(x)-1 do begin
       for j=0,n_elements(y)-1 do begin
           plots, /t3d, [ x(i) ], [ y(j) ], $
             [ z(i,j)+dZ(i,j) ], psym=psym
       endfor
   endfor
   return
end

