pro fpitch_jbf, args
   run = '/home/jbf/work/idl_util/fpitch1125 '+args
   spawn, run

   openr, 10, 'buck_shot_out_jbf', /f77_unformatted
   
   numpoints=long(0)
   readu, 10, numpoints
   time= dblarr(numpoints)
   alpha= dblarr(numpoints)
   speed= dblarr(numpoints)
   fdist= dblarr(numpoints)

   readu, 10, speed
   readu, 10, alpha
   readu, 10, time
   readu, 10, fdist

   close, 10

   species=-1
   if species eq 1 then begin
       mass = 1.67d-24
   endif else begin
       mass = 9.11d-28
   endelse
   qe = 1.6d-19

   energy= 0.5*mass*speed^2/(1d7*qe)

   r=where(energy ne 0.0)  
   colorplot_jbf, alpha, energy, alog10(fdist+1e-38), dx=3, dy=3, $
     xrange=[0,!pi], xstyle=1, /ylog, ytitle='Energy, eV', $
     xticks=4, xtickname=['0','PI/4','PI/2','3*PI/4','PI'], $
     xtitle='Pitch Angle', pixsize=3

   stop

   vperp=speed*sin(alpha)
   vperp=[vperp,-vperp]
   vpara=speed*cos(alpha)
   vpara=[vpara,vpara]
   logf= alog10(fdist+1e-38)
   logf=[logf,logf]
   colorplot_jbf, vperp, vpara, logf, dx=3, dy=3, $
     ytitle='Vpara', $
     xtitle='Vperp', pixsize=3


   return
end





