pro hydra_colorhist, DATA, Z_in, binsize=binsize, min=min, _extra=e, $
                     fill=fill, zrange=zrange, zlog=zlog

   Z= Z_in

   hydra_setcolors, cs
   
   IF NOT keyword_set(binsize) THEN binsize = 1.0
   IF n_elements(min) EQ 0 THEN min = floor(min(data)/binsize)*binsize
   IF n_elements(max) EQ 0 THEN max = floor(max(data)/binsize+1)*binsize

   if n_elements( zrange ) eq 0 then zrange= [ min(Z,max=ma), ma ]
   if keyword_set( zlog ) then begin
       Z= alog10(Z)
       zrange= alog10(zrange)
   endif

   h = histogram(data, min=min, max=max, binsize=binsize)
   n = n_elements(h)+2
   x = findgen(n)*binsize+min-0.5*binsize
   y = [ 0,h,0 ]

   plot, x, y, _extra=e, /nodata

   zcolor= bytscl( Z, top= cs.colortable(1)-cs.colortable(0)+1, $
                   min=zrange(0), max=zrange(1) ) + $
     cs.colortable(0) 

   for color= cs.colortable(1), cs.colortable(0),-1 do begin
       r= where( Zcolor le color )
       h = histogram(data(r), min=min, max=max, binsize=binsize)
       n = n_elements(h)+2
       x = findgen(n)*binsize+min-0.5*binsize
       y = [ 0,h,0 ]
       if keyword_set(fill) then begin
           polyfill, x, y, color=color
       endif else begin
           oplot, x, y, color=color
       endelse
   endfor
end
