; $Id: hyd_crossp.pro,v 1.4 1999/06/07 15:21:48 jbf Exp $

Function hyd_crossp,v1,v2
;
;+
; NAME:
;	HYD_CROSSP
;
; PURPOSE:
;	Evaluate the vector or cross-product of vectors v1 and v2.
;
; CATEGORY:
;	Vector mathematics.
;
; CALLING SEQUENCE:
;	Result = HYD_CROSSP(v1, v2)
;
; INPUTS:
;	v1, v2:  Three-element vectors.
;   OR: v1, v2:  fltarr(3,n)
;
; OUTPUTS:
;	Returns a 3-element, floating-point vector.
;   OR: returns a fltarr(3,n)
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	v1 X v2 = | i  j  k  | = (b1c2 - b2c1)i + (c1a2-c2a1)j + (a1b2-a2b1)k
;		  | a1 b1 c1 |
;		  | a2 b2 c2 |
;
; MODIFICATION HISTORY:
;	Written, DMS, Aug, 1983;
;       Vectorized by Jeremy Faden, Feb, 1999.
;-
  on_error,2                      ;Return to caller if an error occurs
  cross= v1*0
  cross(0,*)= v1(1,*)*v2(2,*)-v2(1,*)*v1(2,*)
  cross(1,*)= V1(2,*)*v2(0,*)-V2(2,*)*v1(0,*)
  cross(2,*)= v1(0,*)*v2(1,*)-v2(0,*)*v1(1,*)
  return,cross
end


