function hyd_f_v, bd, mi, $
                  nsub=nsub, isub=isub, $
                  species=species
  
;  species=[-1|1]

@hd_include
  ttag= hd_timetag_struct
  ttag.bin_width= ( 13.8 / nsub - 1.15 ) / 86400
  ttag.bin_start= gen_time(mi.date) + $
    ( bd.time + isub * ( 13.8 / nsub ) ) / 86400
;
;   Create Timetags for 2 blocks, extract sweep potential for 2+
;   blocks, Keep only if sweep we wished.
;
  ttag_sweeps=replicate(hd_timetag_struct,12)
  ttag_sweeps[*].bin_width=( 13.8 / nsub - 1.15 ) / 86400
  ttag_sweeps[*].bin_start=gen_time(mi.date) + $
    ( bd.time + findgen(12) * ( 13.8 / nsub ) ) / 86400

  hyd_access, ttag_sweeps, 'hrkp_sweep_potential', sweep_pot
  
  sc_pot=sweep_pot(isub)

  phib= bd.phib
  thetab= bd.thetab
  
  sin_thetab= sin(thetab)

  if n_elements( species ) eq 0 then species=-1

  if species lt 0 then begin
      mass = 9.11d-28           ; g
  endif else begin
      mass = 1.67d-24
  endelse

  phase= bd.phase_start + mi.phi_offset

  phib=phib+phase

  bhat= [ [sin_thetab*cos(phib)], [sin_thetab*sin(phib)], [cos(thetab)] ]
  phi_det= bd.phi_det
  det= make_array(384,value=1) # indgen(12)
  box= make_array(384,value=1) # mi.box
  sweep= indgen(384)/16 # replicate(1,12)

  theta_det= bd.theta_ele(det)

;  mask out energy_cal= -17.67 V, nom_energy_index_ref=-12 from box1
  r= where( mi.NOM_ENERGY_INDEX_REF(*,0) eq -12 )
  bd.datamask(r,0)=0
  bd.datamask(r,2)=0
  bd.datamask(r,4)=0
  bd.datamask(r,6)=0
  bd.datamask(r,8)=0
  bd.datamask(r,10)=0

  species_scan=  mi.nom_energy_index_ref < 1 > (-1)

  sub_size= 384/nsub
  rsub= indgen(sub_size) + isub * sub_size

  rspecies= where( species_scan(rsub) eq species )

  r= rsub(rspecies)
  
  sweep= sweep(r,*)
  detector= det(r,*)
  theta_det= theta_det(r,*)
  phi_det= phi_det(r,*)
  bhat1= bhat(r,*)
  bmag= bd.magb(r)
  bvalid= bd.bvalid(r)
  f= bd.f(r,*) & f= reform(f)
  sigma_f= bd.sigma_f(r,*) & sigma_f= reform(sigma_f)
  valid= bd.datamask(r,*)

  rnv= where( bmag eq 1e31 )
  if rnv(0) ne -1 then bmag(rnv)=-1e31
  b54= hd_svmult( bmag, bhat1 )

  energy_nom= mi.energy(*,mi.box)
  energy_nom= energy_nom(r,*)

  if (hd_is_fill(sc_pot)) then sc_pot= bd.sc_potential

  r= where( -1*energy_nom lt sc_pot *1.20 )
  if r(0) ne -1 then valid(r)=0

  energy= energy_nom+sc_pot     ; signed for species

  nn= n_elements( energy )
  bhat= make_array(nn,3)

  twelve_ones= make_array( value=1,12 )
  bhat(*,0)= bhat1(*,0) # twelve_ones
  bhat(*,1)= bhat1(*,1) # twelve_ones
  bhat(*,2)= bhat1(*,2) # twelve_ones
  bmag= bmag # twelve_ones

; ALL REQUIREMENTS HAVE BEEN CALCULATED!!!
;     species, bhat, f, energy, phi_det, theta_det

  v_mag= sqrt( abs(energy) * 1.6e-19 * 1d7 * 2 / mass )

  nn= n_elements( v_mag )

  v= fltarr(nn,3)
  sin_theta_det= sin( theta_det )

  v(*,0)= v_mag * [sin_theta_det*cos(phi_det)]
  v(*,1)= v_mag * [sin_theta_det*sin(phi_det)]
  v(*,2)= v_mag * [cos(theta_det)]

  hd_fill= -1e31
  n= hd_fill
  ele_v= [1,1,1]*hd_fill
  ele_v_perp= [1,1,1]*hd_fill


  common su_form_data_common_2, mom_timetags, T_day
  if n_elements( mom_timetags ) eq 0 then begin
      hyd_access, mom_timetags, 'ele_t', T_day, $
        get_timetags= gen_time( mi.date ) + [0,1]
  endif
  x= min( abs( ttag.bin_start + ttag.bin_width/2  - $
               mom_timetags(*).bin_start + mom_timetags(*).bin_width/2 ), imin )
  T= T_day(imin)

;  hyd_access, ttag, 'ele_v_perp', ele_v_perp
;  ele_v= ele_v_perp

;  cdf_varget, mi.l1stat.calid, rec_start=bd.blocknum, 'HRKP_MEAN_ENERGY', T_eV
;  T= T_eV * 11605.

  B_var= fltarr(3)
  r= where( bvalid, count )
  if count gt 0 then begin
      B= total( b54(r,*), 1 ) / count
      B_var(0)= sqrt( total( ( b54(r,0)-B(0) )^2 ) ) / count
      B_var(1)= sqrt( total( ( b54(r,1)-B(1) )^2 ) ) / count
      B_var(2)= sqrt( total( ( b54(r,2)-B(2) )^2 ) ) / count      
      bhat_avg= fltarr(3)
      bhat_avg(0)= total( b54(r,0)/bmag(r) ) / count
      bhat_avg(1)= total( b54(r,1)/bmag(r) ) / count
      bhat_avg(2)= total( b54(r,2)/bmag(r) ) / count
      bhat_avg_mag= sqrt( total( bhat_avg^2 ) )
      bhat_avg= bhat_avg / bhat_avg_mag
      bhat_N= count
;      bhat_avg= b / hd_magnitude( B )
  endif else begin
      B= [1,1,1]*(-1e31)
      B_var(*)= -1e31
      bhat_avg= [1,1,1]*(-1e31)
      bhat_avg_mag= -1e31
      bhat_n= 0
  endelse

  bvalid_unroll= bvalid # replicate( 1., 12 )
  r= where( bvalid_unroll eq 0, count )
  if r(0) eq 0 then begin
      bhat(r,0)= bhat_avg(0)
      bhat(r,1)= bhat_avg(1)
      bhat(r,2)= bhat_avg(2)
  endif

  common su_form_data_common, date0, ele_v1, ele_v1_time
  if n_elements( date0 ) eq 0 then read=1 else begin
      if date0 ne mi.date then read=1 else read=0
  endelse
  
  if read then begin
      time_range= gen_time(mi.date) + [0,1]
;      oldpath= getenv( 'HYDRA_MOMENTS_DATA_PATH' )
;      setenv, 'HYDRA_MOMENTS_DATA_PATH=/opt/hydra/moment_code/develop/wind/'
      hyd_access, ttag_mom, 'ele_v', ele_v1, get_timetags= time_range
;      setenv, 'HYDRA_MOMENTS_DATA_PATH='+oldpath
      ele_v1_time= hd_time_hr( ttag_mom )
      date0= mi.date
  endif
  
  x= min( abs( bd.time + isub * ( 13.8 / nsub ) - ele_v1_time ), imin )
  ele_v= reform(ele_v1(imin,*)) 
  
  uparl_vec= total( ele_v*bhat_avg ) * bhat_avg
  ele_v_perp= ( ele_v - uparl_vec ) 
  
  yhat= [1,1,1]*hd_fill
  zhat= [1,1,1]*hd_fill
  
  time_range= dblarr(2)
  time_range(0)= ( bd.time + isub*(13.8/nsub) )/ 86400 + gen_time( date )
  time_range(1)= time_range(0) + ( 13.8 / nsub - 1.15 )/86400
  
  time_range= time_range + gen_time( date=mi.date )

  b1= [ -bhat_avg(1), bhat_avg(0), 0 ]
  if hd_magnitude(b1) eq 0. then begin
      b1= [0., bhat_avg(2), -bhat_avg(1) ]
  endif
  base1= b1/hd_magnitude(b1)
  base2= hd_crossp( temporary(b1), bhat_avg )
  
  data= { v:v, $                ; cm/s
          f:f(*), $
          sigma_f:sigma_f(*), $
          detector:detector(*), $
          sweep:sweep(*), $
          valid:valid(*), $
          potential:sc_pot, $
          bhat:bhat, $
          bmag:bmag(*), $
          yhat:yhat, $
          zhat:zhat, $
          kT_parl:T, $          ; K
          kT_perp:T, $          ; K
          mass:mass, $
          B:B, $
          Bhat_avg:bhat_avg, $
          bhat_avg_mag:bhat_avg_mag, $
          bhat_N:bhat_N, $
          B_var:B_var, $
          base1:base1, $
          base2:base2, $
          b_valid:bvalid_unroll(*), $
          U:ele_v, $
          Uperp:ele_v_perp, $
          uperp_start:fltarr(3), $
          time_range:time_range,$
          species:species, $
          model:bd.model, $
          block:bd.blocknum, $
          isub:isub $
        }
  x= check_math()
  return, data

end


