;+
; NAME: hyd_rotm
;
; PURPOSE: return the 3x3 rotation matrix for a rotation about an axis
;
; CATEGORY: 
;
; CALLING SEQUENCE: matrix= hyd_rotm(angle_rad)
; 
; INPUTS:
;   angle_rad   angle of rotation
;
; KEYWORD PARAMETERS:
;   axis=[0|1|2]   rotate about x, y, or z.  z is default.
;    NOT SUPPORTED YET!
;
; OUTPUTS:
;   returns fltarr(3,3)
;
; PROCEDURE:
;
; EXAMPLE:
;   vec_new= hyd_rotm(45*!dtor) # [1,0,0]
;
; MODIFICATION HISTORY:
;   written, jbf, University of Iowa, 2002 March 12.
;-
  
function hyd_rotm, angle, axis=axis
  if n_elements(axis) eq 0 then axis=2
  if axis ne 2 then begin
      message, 'Only rotations about Z axis are supported at this time.'
  endif
  
  matrix= [[ cos(angle),  sin(angle),  0 ], $
           [ -sin(angle), cos(angle),  0 ], $
           [ 0,           0,           1 ]]
  return, matrix
  
end

