;+
; NAME: hyd_str_join
;
; PURPOSE: combine array of strings into one string with delimeter 
;    in between.  This might be thought of as the inverse of str_sep().
;
; CATEGORY: string utility
;
; CALLING SEQUENCE: result= str_join( parts, separator )
; 
; INPUTS: 
;   parts      an array of strings
;   separator  a string to put between the parts
;
; OPTIONAL INPUTS: none
; KEYWORD PARAMETERS: none
; OUTPUTS: 
;   returns a string 
;
; OPTIONAL OUTPUTS: none
; COMMON BLOCKS: none
; SIDE EFFECTS: none
; RESTRICTIONS: none
;
; PROCEDURE:
;   loop over parts, concatenating it plus the separator into result string
;
; EXAMPLE:
;   print, hyd_str_join( str_sep( '/dir1/dir2', '/' ), '\' )
;
; MODIFICATION HISTORY:
;   written, jbf, University of Iowa, 2002 March 12.
;-

function hyd_str_join, array, sep
  result= array[0]
  for i=1,n_elements(array)-1 do result= result + sep + array[i]
  return, result
end

