pro hyd_usage, routine_in
;+
; NAME: hyd_usage
;
; PURPOSE: routine the source file for a given routine
;
; CATEGORY:
;
; CALLING SEQUENCE: hyd_usage, routine
; 
; INPUTS: 
;   routine,  string that is the name of the routine (no .pro)
;
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;   prints the a short statement about the usage of the routine.
;
; SIDE EFFECTS:
;   automatically compiles the routine if it is not compiled.
;
; RESTRICTIONS:
;   calls and parses the output of "help, source."  IDL discourages
;   this practice and reserves the right to make changes to the help
;   output format.  This may cause this code to fail in future
;   revisions of IDL.
;
;   Also, the filename and paths may contain spaces, and the code can
;   handle this! 
;
;   Does not work under IDL 4.0
;
; PROCEDURE:
;   call "help, /routine", and parse output.
;
; EXAMPLE:
;   hyd_usage, 'which'
;
; MODIFICATION HISTORY:
;   written, jbf, January, 2002.  University of Iowa
;-

  if float(!version.release) lt 5.1 then begin
      message, 'IDL version lt 5.1.  This function not supported.', /cont
      return
  endif
  
  if (strpos( routine_in, '.' ))(0) ne -1 then begin
      s= str_sep( routine_in, '.' )
      routine= strupcase(s(0))
  endif else begin
      routine= strupcase(routine_in)
  endelse
  
  help, /routine, output= help_out
  r= where( strmid( help_out, 0, strlen(routine)+1 ) eq $
            routine+' ' )
  
  if r(0) eq -1 then begin
      resolve_routine, routine
      help, /routine, output= help_out
      r= where( strmid( help_out, 0, strlen(routine)+1 ) eq $
                routine+' ' )
  endif
  
  if r(0) eq -1 then begin
      message, "Can't find routine: "+routine+'.', /cont
      file=''
      return
  endif else begin      
      idx= r(0)
      parseme= help_out(idx)
      s= str_sep( parseme, ' ' )
      r= where( s ne '', count )
      if count eq 1 and idx lt n_elements(help_out)-2 then begin
          parseme= help_out(idx)+help_out(idx+1)
          s= str_sep( parseme, ' ' )
          r= where( s ne '', count )
      endif
      s= str_sep( parseme, ' ' )
      r= where( s ne '' )
      s= s(r)
      if n_elements(s) ge 1 then begin
          file= s(1)
          for i=2,n_elements(s)-1 do file=file+' '+s(i)
      endif else begin
          message, "can not locate routine "+routine, /cont
          file=''
      endelse

      f_str= 'Compiled Functions:'
      idx_f= where( strmid( help_out, 0, strlen(f_str) ) eq f_str )
      
      is_function= idx gt idx_f

  endelse

  function_str= ( [ 'PRO', 'FUNCTION' ] ) ( is_function )

  print, '----------------------------------'
  print, function_str + ' ' + routine+': '+file
  print, '----------------------------------'
  
end

