pro hydra_circle_plot, z_arg, X=X,Y=Y,Z=Z_in, _extra=plot_par, $
                       help=help, $
                       min_value=min_value, max_value=max_value, $
                       overplot=overplot
;+
; NAME: hydra_circle_plot
;
;
;
; PURPOSE: display 3d data in monochromatic display, w/o 3d space xform.
;   Use circles with radii proportional to Z
;
;
; CATEGORY: plotting
;
;
;
; CALLING SEQUENCE: hydra_circle_plot, Z
;                   hydra_circle_plot, x=x, y=y, z=z
;
;
; 
; INPUTS: Z data, X, and Y locations
;
;
;
; OPTIONAL INPUTS: 
;
;
;	
; KEYWORD PARAMETERS:
;      /overplot    overplot existing plot, like contour
;      min_value, max_value   exclude these data
;
; OUTPUTS:
;      (to display)
;
;
; OPTIONAL OUTPUTS:
;
;
;
; COMMON BLOCKS:
;
;
;
; SIDE EFFECTS:
;
;
;
; RESTRICTIONS:
;
;
;
; PROCEDURE:
;
;
;
; EXAMPLE:
;
;
;
; MODIFICATION HISTORY:
;
;-


; two input formats: X,Y,Z scatter plot, or
;    Z, a two-D array with X and Y indicating grid values
  
  if n_params() eq 1 then begin
      Z= Z_arg
  endif else begin
      Z= Z_in
  endelse

  s= size(Z)
  if s(0) eq 2 then begin
      if n_elements(X) eq 0 then X=lindgen(s(1))
      if n_elements(Y) eq 0 then Y=lindgen(s(2))
;     reform to scatter format
      i=lindgen( s(4) )         ;total number of elements
      X=X( i mod s(1) ) + 0.5
      Y=Y( i / s(1) ) + 0.5
      Z=Z( i )
  endif          

  if n_elements( min_value ) eq 1  then begin
      r= where( Z ge min_value )
      if r(0) eq -1 then r=0
      X=X(r)
      Y=Y(r)
      Z=Z(r)
  endif
      
  if n_elements( max_value ) eq 1 then begin
      r= where( Z le max_value )
      if r(0) eq -1 then r=0
      X=X(r)
      Y=Y(r)
      Z=Z(r)
  endif
      
  if not keyword_set(overplot) then plot, X, Y, /nodata, _extra=plot_par

  zmax= max(z) * 2
  
  a= findgen(36)/35 * 2 * !pi
  cx=cos(a) & cy= sin(a)
  
  for i=0, n_elements(Z)-1 do begin
      oplot, cx*z(i)/zmax+X(i), cy*z(i)/zmax+Y(i)
  endfor

  return
end


