pro hydra_colorplot, zmat, zrange=zrange, zlog=zlog, _extra=e, colors=colors

  if n_params() eq 0 then begin
      print, 'USAGE: '
      print, 'pro hydra_colorplot, zmat, zrange=zrange, zlog=zlog,'+$
        ' _extra=e, colors=colors'
      print, '   zmat is a 2D array '
      print, '   colors is the number of colors'
      stop, ' '
  endif

  zlog=keyword_set(zlog)

  if not keyword_set(zrange) then begin
      zrange=dblarr(2)
      zrange(0)=min(zmat)
      zrange(1)=max(zmat)  
  end

  if not keyword_set(colors) then begin
      colors= intarr(2)
      colors(0)= 0
      colors(1)= !d.n_colors-1
  endif
  ncolors= colors(1)-colors(0)+1
      
  rzero= where( zmat lt zrange(0) )
  rsat= where( zmat gt zrange(1) )
  if (rzero(0) ne -1) then zmat(rzero)= zrange(0)

  if (zlog) then begin
      logrange= alog10( zrange(1)/zrange(0) )
      logmin= alog10( zrange(0) )
      cmap= ( alog10( zmat ) - logmin ) / logrange * ncolors + colors(0)
  endif else begin
      range= zrange(1) - zrange(0)
      cmap= (zmat-zrange(0))/range * ncolors + colors(0)
  endelse

  if (rzero(0) ne -1) then cmap(rzero) = colors(0)
  if (rsat(0) ne -1) then cmap(rsat) = colors(1)

  plot, [0,1], /nodata, _extra=e
  !p.multi=!p.multi+[1,0,0,0,0]
  
  ylog=!y.type
  
  if (ylog) then begin
      ll= convert_coord( !x.crange(0), 10^!y.crange(0), /data, /to_device )
      ur= convert_coord( !x.crange(1), 10^!y.crange(1), /data, /to_device )
  endif else begin
      ll= convert_coord( !x.crange(0), !y.crange(0), /data, /to_device )
      ur= convert_coord( !x.crange(1), !y.crange(1), /data, /to_device )
  endelse
  
  tv, congrid( cmap, ur(0)-ll(0), ur(1)-ll(1) ), ll(0), ll(1)
  plot, [0,1], /nodata, /noerase, _extra=e

  !p.multi=!p.multi-[1,0,0,0,0]
  
  return
end
