pro hydra_digiplot, z_arg, X=X,Y=Y,Z=Z_in, _extra=plot_par, $
                    format=format, help=help, $
                    min_value=min_value, max_value=max_value, $
                    overplot=overplot

  if keyword_set(help) or $
    ( n_elements(z_arg) + n_elements(z_in) eq 0 )  then begin
      print, 'pro hydra_digiplot, X=X,Y=Y,Z=Z, _extra=plot_par, format=format, help=help, $'
      print, '   min_value=min_value, max_value=max_value'
      return
  endif
  
  if not keyword_set( format ) then format='(i9)'

; two input formats: X,Y,Z scatter plot, or
;    Z, a two-D array with X and Y indicating grid values
  
  if n_params() eq 1 then begin
      Z= Z_arg
  endif else begin
      Z= Z_in
  endelse

  s= size(Z)
  if s(0) eq 2 then begin
      if n_elements(X) eq 0 then X=lindgen(s(1))
      if n_elements(Y) eq 0 then Y=lindgen(s(2))
;     reform to scatter format
      i=lindgen( s(4) )         ;total number of elements
      X=X( i mod s(1) ) + 0.5
      Y=Y( i / s(1) ) + 0.5
      Z=Z( i )
  endif          

  if n_elements( min_value ) eq 1  then begin
      r= where( Z ge min_value )
      if r(0) eq -1 then r=0
      X=X(r)
      Y=Y(r)
      Z=Z(r)
  endif
      
  if n_elements( max_value ) eq 1 then begin
      r= where( Z le max_value )
      if r(0) eq -1 then r=0
      X=X(r)
      Y=Y(r)
      Z=Z(r)
  endif
      
  if not keyword_set(overplot) then plot, X, Y, /nodata, _extra=plot_par
  
  for i=0L, n_elements(Z)-1 do begin
      str= strtrim( string( Z(i), format=format ),2 )
      xyouts, X(i), Y(i), str
  endfor

  return
end


