pro idl_path_grep, str, display=display
;+
; NAME: idl_path_grep
; PURPOSE: "greps" all files on the IDL search path for a string.
; CATEGORY: utility
; CALLING SEQUENCE: idl_path_grep, <search_string>
; INPUTS:  search_string,  an IDL string containing the text to look for  
; KEYWORD PARAMETERS: display=n, display line and next (n-1) lines
; OUTPUTS: to stdout.
; PROCEDURE: parse !path; loop over directories, grepping each
; directory for search_string, record filename containing string.  IF
; display keyword is set, then for each filename, search for text,
; then print following lines.
; EXAMPLE: idl_path_grep, 'common hydra_spec_data', display=12
; MODIFICATION HISTORY: written, February 22, 1999.
;
;-
   s= str_sep( !path, ':' )
   files=['']
   for i=0,n_elements(s)-1 do begin
       print, format='(a,$)', '.'
       spawn, 'grep -i "'+str+'" '+s(i)+"/*.pro | grep -v 'pro:;' ", result
       if result(0) ne '' then begin
           for j=0,n_elements(result)-1 do begin
               files= [ files,(str_sep(result(j),':'))(0) ]               
           endfor
       endif
   end

   files= files[1:*]
   u= uniq(files)
   files= files[u]

   if n_elements( display ) gt 0 then begin
       print, files
       nlines=display
       for i=0,n_elements(files)-1 do begin
           print, '****** ' + files(i) + ' ******'
           openr, 10, files(i)
           s= '' & done=0
           repeat begin
               readf, 10, s
               if strpos(s,str) ne -1 then begin
                   print, s
                   for j=1,nlines do begin
                       if eof(10) then j=nlines else begin
                           readf, 10, s
                           print,s
                           done=1
                       endelse
                   endfor
               endif
           endrep until eof(10) or done
           close, 10
       endfor
   endif else begin
       for i=0,n_elements(files)-1 do begin
           print, files[i]
       endfor
   endelse
end
   

