function jbf_hms, dh, string=string
;  convert decimal hour to hms
   hr = fix( dh )
   mn = fix( ( dh - hr ) * 60 )
   sec = fix( ( ( dh - hr ) * 3600 - mn * 60 ) + 0.5 ) 
   
   if keyword_set( string ) then begin
       n= n_elements(hr)
       s= strarr(n_elements(hr))
       for i=0,n-1 do begin
           s(i)= string(hr(i),form='(i2.2)') + ':' + $
             string(mn(i),form='(i2.2)') + ':' + $
             string(sec(i),form='(i2.2)')
       endfor
       return, s
   endif else begin
       return, hr + mn / 100. + sec / 10000.
   endelse
end

function jbf_dh, hms, string=string
;  convert hms (hh.mmss) to decimal hour
   hr = fix( hms )
   mn = fix( ( hms - hr ) * 100 )
   sec = fix( ( ( hms - hr ) * 10000 - mn * 100 ) ) 

   if keyword_set( string ) then begin
       n= n_elements(hr)
       s= strarr(n_elements(hr))
       for i=0,n-1 do begin
           s(i)= string(hr(i),form='(i2.2)') + ':' + $
             string(mn(i),form='(i2.2)') + ':' + $
             string(sec(i),form='(i2.2)')
       endfor
       return, s
   endif else begin
       return, hr + mn / 60. + sec / 3600.
   endelse
end

function to_time_std, time_in
   time= time_in
   if time gt 1e8 then begin
       time = time mod 86400000. ; milliseconds since midnight
       time = time / 1000.      ; seconds since midnight
   endif
   hydra_time_io, 0, time, year, month, day, hour, minute, second
   timeout= string( hour, minute, second, format="(i2.2,':',i2.2,':',i2.2)" )
   return, timeout
end
