PRO legend, lines, colors, pos=pos, title=title
;
;  Plots a legend on your plot
;
;  lines is a string array
;  colors is an array of color names
;
;  pos is a 2x4 array showing the corners
;
;  title is the title to give the legend, default is 'Legend'
;
;
;
   IF NOT keyword_set(title) THEN title = 'Legend'
   IF NOT keyword_set(pos) THEN $
    pos = [[0.2,0.2], [0.2,0.4], [0.4,0.4], [0.4,0.2]]

   corner = reform([[reform(pos(0,*),4),pos(0,0)],[reform(pos(1,*),4),pos(1,0)]],5,2)
   n = (n_elements(colors)+2)
   dx = (max(corner(*,0),min=minx)-minx)/n
   dy = (max(corner(*,1),min=miny)-miny)/n

   x0 = minx+dx*n*0.5
   y0 = miny

   plots, corner(*,0), corner(*,1), /normal
   xyouts, x0, y0+dy*(n-1), align=0.5, title, /normal
   FOR i=0,n_elements(colors)-1 DO $
    xyouts, x0, y0+dy*(i+0.5), align=0.5, lines(i), color=get_color_index(colors(i)), /normal

   return
END
