pro mywindow_kill, id
   id= long(id)
   child= widget_info( id, /child )
   widget_control, id, get_uvalue= widgetData

   !p= widgetData.p0
   !x= widgetData.x0
   !y= widgetData.y0
   !z= widgetData.z0
   tvlct, widgetData.r0, widgetData.g0, widgetData.b0

;  destroy widget if not called by xmanager
   help, call=c
   called_by= (str_sep(c(1),' '))(0)
   if called_by ne 'XUNREGISTER' then widget_control, id, /destroy

end

pro mywindow_event, event
   widget_control, event.id, get_uvalue= uval
   widget_control, event.top, get_uvalue= widgetData

   if event.id eq event.top then begin
       xsize= event.x
       ysize= event.y
       widget_control, widgetData.draw_id, xsize=xsize, ysize=ysize

       return
   endif

   if uval eq 'close' then begin
       widget_control, event.top, /destroy
   endif

end

pro mywindow, num, title=title

   if n_elements( num ) eq 0 then num=0

   w= widget_base( )

   if n_elements( title ) eq 0 then begin
       title='Window (base='+strtrim(w+1,2)+')'
   endif
   
   widget_control, w, /destroy
   w= widget_base( title=title, /col, $
                   /tlb_size_events )
   
;     using a first child to store data doesn't work, because of the
;     kill method.
 
   d= widget_draw( w, xsize=600, ysize=400 )
   
   x= widget_label( w, value='type "mywindow_kill, id" to explicitly kill' )

   b= widget_button( w, value='Close', uvalue='close' )
   widget_control, w, /realize
   
   widget_control, d, get_value=winidx
   wset, winidx

   tvlct, /get, r0, g0, b0

   widgetData= { $
                 draw_id:d, $
                 winidx:winidx, $
                 x0: !x, $
                 y0: !y, $
                 z0: !z, $
                 p0: !p, $
                 r0: r0, $
                 b0: b0, $
                 g0: g0 $
               }
   
   plot_state, /reset   
   loadct, 0

   widget_control, w, set_uvalue=widgetData
 
   xmanager, 'mywindow', w, /just_reg, cleanup='mywindow_kill'
end

