pro pie_chart, values, labels
   angle= !pi * 2 * findgen(721)/720
   cirx= cos( angle )
   ciry= sin( angle )
   pp=0.
   other=0.
   tv= total(values)
   plot, [-2,2],[-2,2], xstyle=5, ystyle=5, /nodata
   s=1.
   icolor=1
   for i=0,n_elements(labels)-1 do begin
       p1= values(i)/tv * !pi * 2
       r= where( angle ge pp and angle le p1+pp, count )
       if p1 gt 2.5*!dtor then begin
           polyfill, [0,cirx(r),0], [0,ciry(r),0], $
             color= (icolor mod 2) *40 + 20
           plots, [0,cirx(r),0], [0,ciry(r),0], $
             color= !p.background
           label_angle= angle(r(count/2))
           if label_angle/!dtor gt 90 and label_angle/!dtor lt 270 then begin
               xyouts, cirx(r(count/2)), ciry(r(count/2)), /data, $
                 labels(i)+'  ', $
                 orient=180+label_angle/!dtor, align=1
           endif else begin
               xyouts, cirx(r(count/2)), ciry(r(count/2)), /data, $
                 '  '+labels(i), $
                 orient=label_angle/!dtor
           endelse
           icolor=icolor+1
           wait, 0.4
           pp= pp+p1
       endif else begin
           other= other+p1
       endelse
   endfor

   r= where( angle ge pp and angle le pp+other, count )
   if count gt 3 then begin
       polyfill, [0,cirx(r),0], [0,ciry(r),0], $
         color= (icolor mod 2) *40 + 20
       label_angle= angle(r(count/2))
       other_label= '<other>'
       if label_angle/!dtor gt 90 and label_angle/!dtor lt 270 then begin
           xyouts, cirx(r(count/2)), ciry(r(count/2)), /data, $
             other_label+'  ', $
             orient=180+label_angle/!dtor, align=1
       endif else begin
           xyouts, cirx(r(count/2)), ciry(r(count/2)), /data, $
             '  '+other_label, $
             orient=label_angle/!dtor
       endelse
       icolor=icolor+1
   endif
end   
