pro plot_f_v, f, vparl, vperp
  speed= sqrt( vperp^2 + vparl^2 )
  mass = 9.11d-28
  energy= 0.5 * mass * speed^2 / ( 1.6e-19 * 1d7 )
  plot, energy, f, /ylog, psym=3, /nodata, xrange=[0,1e3]
  dots, /fill

;  legend
  angle= findgen(360)/359 * 2 * !pi
  radius=0.05
  pix= 0.05 * !d.x_size
  oo= [ 0.7, 0.8 ] * [ !d.x_size, !d.y_size ]
  plots, oo[0] + cos(angle)*pix, $
    oo[1] + sin(angle)*pix, /device
  plots, oo[0] + [0,pix*1.20], [1,1]*oo[1], /device
  pix= pix*0.90

  pitch= atan( vperp, vparl )

  cone=30

  r= where( pitch le (180-30)*!dtor  $
            and  pitch ge 30*!dtor )
  if r[0] ne -1 then begin
      oplot, energy[r], f[r], psym=8, symsize=0.2,color=get_color_index('grey')
      plots, cos(pitch[r])*pix+oo[0], sin(pitch[r])*pix+oo[1], psym=8, symsize=0.2, $
        /device,color=get_color_index('grey')
  endif
  
  r= where( pitch lt 30*!dtor )
  if r[0] ne -1 then begin
      oplot, energy[r], f[r], psym=8, symsize=0.5,color=get_color_index('red')
      plots, cos(pitch[r])*pix+oo[0], sin(pitch[r])*pix+oo[1], psym=8, symsize=0.2, $
        /device, color=get_color_index('red')
  endif

  r= where( pitch gt (180-30)*!dtor )
  if r[0] ne -1 then begin
      oplot, energy[r], f[r], psym=8, symsize=0.5,color=get_color_index('blue')
      plots, cos(pitch[r])*pix+oo[0], sin(pitch[r])*pix+oo[1], psym=8, symsize=0.2, $
        /device,color=get_color_index('blue')
  endif

end


