pro plot_page, pdef, arg1_in, arg2_in, $		
               nh=nh, nv=nv, nplots=nplots, title=title, $
               nostamp=nostamp, $
               init=init, reset=reset, send=send, $
               next=next, plot=plot, help=help, $
               overplot=overplot, $
               $
               set_plot=set_plot, landscape=landscape, portrait=portrait, $
               filename=filename, $
               explicit_filename= explicit_filename_in, $
               print=print, $
               noautoclear=noautoclear, $
               noerase= noerase, $
               $
               ps_onefile=ps_onefile, $
               $
               nohidelabel=nohidelabel, $
               position=position, region=region, $
               xspace=xspace, yspace=yspace, $
               $
               anti_alias=anti_alias, $
               $
               _extra=plotParm, $ 
               pparm=plotParm_out ; output
;+
;plot_page utility 
;
;/init   initialize the page
;  nh=nh
;  nv=nv
;  nplots=nplots  ; calculates nh and nv automatically.
;  /nostamp       ; don't print time stamp
;  xspace=xspace
;  yspace=yspace
;  title=title
;  /print
;    filename=filename
;    /portrait
;    /landscape
;  /noautoclear   ; no auto send
;  /nohidelabel   ; print axis labels on all plots.
;/plot   start new plot
;/overplot  ???
;/send   send page to output device
;/next   empty plot
;-

  
  if n_elements( arg1_in ) gt 0 then arg1= arg1_in
  if n_elements( arg2_in ) gt 0 then arg2= arg2_in
   
   if keyword_set(help) then begin
       doc_library, 'plot_page'
       return
   endif

  common plot_page_common, device_spec

  init=keyword_set(init)        ; define pdef, etc...
  reset=keyword_set(reset)      ; resets 
  send=keyword_set(send)        ; sends plot to printer and reset
  next=keyword_set(next)        ; sets position 
  plot=keyword_set(plot)        ; plot page call is plot call 
  restore=keyword_set(restore)  ; restores old x, y, z, p variables
  overplot=keyword_set(overplot)
  onefile= keyword_set(ps_onefile)
  anti_alias= keyword_set(anti_alias)

  noerase= keyword_set( noerase )
  if noerase then begin
      noautoclear=1
  endif else begin
      if not keyword_set( set_plot ) and (init) then set_plot=!d.name
  endelse

;  nplots can be used to automatically set nh and nv.
  if keyword_set(nplots) and $
    not keyword_set(nh) and not keyword_set(nv) then begin
      nv= fix( sqrt( nplots) )
      nh= ceil( nplots/float(nv) )
  endif

  if not keyword_set(nh) then nh=1
  if not keyword_set(nv) then nv=1
  if n_elements(nplots) eq 0 then nplots=nh*nv

  hidelabel= not keyword_set( nohidelabel )

  noautoclear= keyword_set( noautoclear )
  landscape=keyword_set(landscape)
  portrait= keyword_set(portrait)
  if portrait eq 0 and landscape eq 0 then landscape=1
  if portrait eq 1 and landscape eq 1 then portrait=0

  if keyword_set( print ) then begin
      if (size(print))(1) eq 7 then begin
          if print eq 'file' then print2file=1 else printer_name=print 
      endif else begin
          set_plot='ps'
          printer_name='ggs_laser'
      endelse
  endif      
          
  print2file= keyword_set(print2file)
  if not keyword_set(filename) then filename='page'

  if n_elements(region) ne 4 and n_elements(position) ne 4 then $
    region=[0,0,1,1]
  if n_elements(region) eq 4 then begin
      if nplots eq 1 then begin
          ll=[ (region(2)-region(0))*0.15 + region(0), $
               (region(3)-region(1))*0.10 + region(1) ]
          ur=[ (region(2)-region(0))*0.90 + region(0), $
               (region(3)-region(1))*0.90 + region(1) ]
      endif else begin          
          ll=[ (region(2)-region(0))*0.075 + region(0), $
               (region(3)-region(1))*0.050 + region(1) ]
          ur=[ (region(2)-region(0))*0.975 + region(0), $
               (region(3)-region(1))*0.950 + region(1) ]
      endelse
      position=[ll,ur]
  endif
  if hidelabel then begin
      if not keyword_set(xspace) then xspace=0.15
      if not keyword_set(yspace) then yspace=0.15
  endif else begin
      if not keyword_set(xspace) then xspace=0.35
      if not keyword_set(yspace) then yspace=0.35
  endelse
      
  if not keyword_set(title) then title=' '  
  if not keyword_set(xtitle) then xtitle=' '
  if not keyword_set(ytitle) then ytitle=' '
  stamp= not keyword_set(nostamp)

  if keyword_set(set_plot) then begin
      set_plot= strlowcase(set_plot)
      spawn, "echo $$", uniqueid &  uniqueid=strtrim(uniqueid(0),2)
      print2file= keyword_set(print2file)
      if n_elements( explicit_filename_in ) eq 0 then begin
          explicit_filename= filename+uniqueid+'.'+set_plot
      endif else begin
          explicit_filename= explicit_filename_in
      endelse
      case set_plot of
          'ps': begin
              set_plot, set_plot
              if landscape then begin
                  xs=10.0 & ys=7.5
                  xoffset=0.5 & yoffset=10.5
              endif else begin
                  xs=7.5 & ys=10.0
                  xoffset=0.5 & yoffset=0.5
              endelse
              device, xsize=xs, ysize=ys, /inches, landscape=landscape,$
                filename=explicit_filename, $
                xoffset=xoffset, yoffset=yoffset, $
                /color, bits=8
              default_printer_name='ggs_laser'
              device_type='printer'
          end
          'pcl': begin
              set_plot, set_plot
              if landscape then begin
                  xs=10.0 & ys=7.5
                  xoffset=0.0 & yoffset=0.0
              endif else begin
                  xs=7.5 & ys=10.0
                  xoffset=0.0 & yoffset=0.0
              endelse
              device, xsize=xs, ysize=ys, /inches, landscape=landscape,$
                filename=explicit_filename, /color, $
                xoffset=xoffset, yoffset=yoffset
              default_printer_name='cis_color'
              device_type='printer'
              !p.color=0
              !p.background=!d.n_colors-1
          end
          'x': begin
              if !version.os_family eq 'windows' then set_plot, 'win' else $
                set_plot, set_plot
              set_plot, set_plot
              device_type='display'
              default_printer_name=' '
              erase
          endif
      endcase
      if not keyword_set(printer_name) then $
        printer_name=default_printer_name

      autoclear= not noautoclear
      
      device_spec= { device_spec_struct, $
                     name:set_plot, $
                     device_type:device_type, $
                     filename_pre:filename, $
                     filename:explicit_filename, $
                     send_page:0, $ ; flag that a printable page needs sending
                     draw_title:1, $ ; request that title be printed
                     autoclear:autoclear, $ ; send at page completion
                     onefile:onefile, $ ; send each page to one file.
                     printer_name:printer_name, $
                     print2file:print2file, $
                     oldX:!X, $
                     oldY:!Y, $
                     oldZ:!Z, $
                     oldP:!P $
                   } 
  endif ; set_plot


  if init then begin

;     calculate origin and deltaplot
      xorigin= position(0)      
      yorigin= position(1)

      plotwidth= (position(2)-position(0)) / ( nh + nh*xspace - xspace )
      plotheight= (position(3)-position(1)) / ( nv + nv*yspace - yspace/1.5 )

      xdeltaplot= plotwidth * ( 1+xspace )
      ydeltaplot= plotheight * ( 1+yspace )      

;  now we need to add needed fields to plotParm struct.
      nullticks= replicate('',30)
      if n_elements( plotParm ) eq 0 then $
        plotParm={ xtitle:'' }  ; just to get it started
      tags= tag_names( plotParm )

;     attempt to check for any possible keyword.  (*sigh*)  See !axis.
      if (where( tags eq 'XTICKNAME' ))(0) eq -1 then $
        plotParm= create_struct( plotParm, { xtickname:nullticks } )
      if (where( tags eq 'YTICKNAME' ))(0) eq -1 then $
        plotParm= create_struct( plotParm, { ytickname:nullticks } )
      if (where( tags eq 'XTITLE' ))(0) eq -1 then $
        plotParm= create_struct( plotParm, { xtitle:' ' } )
      if (where( tags eq 'YTITLE' ))(0) eq -1 then $
        plotParm= create_struct( plotParm, { ytitle:' ' } )
      if (where( tags eq 'XTICKFORMAT' ))(0) eq -1 then $
        plotParm= create_struct( plotParm, { xtickformat:'' } )
      if (where( tags eq 'YTICKFORMAT' ))(0) eq -1 then $
        plotParm= create_struct( plotParm, { ytickformat:'' } )
      if (where( tags eq 'XLOG' ))(0) eq -1 then $
        plotParm= create_struct( plotParm, { xlog:0 } )
      if (where( tags eq 'YLOG' ))(0) eq -1 then $
        plotParm= create_struct( plotParm, { ylog:0 } )

      if (where( tags eq 'NOERASE' ))(0) eq -1 then $
        plotParm= create_struct( plotParm, { noerase:1 } )

      plotParm= create_struct( name='plotParm_struct', $
                               plotParm, { position:position } )

      pdef= { pdef_struct, $
              next_plot_number:0, $
              number_of_plots:nplots, $
              horizontal_panels:nh, $
              vertical_panels:nv, $
              xorigin:xorigin, $
              yorigin:yorigin, $
              xdeltaplot:xdeltaplot, $
              ydeltaplot:ydeltaplot, $
              plotwidth:plotwidth, $
              plotheight:plotheight, $
              title:title, $
              draw_title:1, $
              hidelabel:hidelabel, $
              plotParms:plotParm, $
              x:!x, $
              y:!y $
            }

      pdef.draw_title=1
      titlepos= ( position(3)-position(1) ) * 1.03 + position(1)
      xyouts, position(0), titlepos, title, /normal, charsize=1.1
      pdef.draw_title=0
      if (stamp) then time_stamp ; known bug: only stamps first page
      
  endif else if restore then begin
      !x=device_spec.oldx
      !y=device_spec.oldy
      !z=device_spec.oldz
      !p=device_spec.oldp
  endif else if reset then begin
      pdef.next_plot_number=0
  endif else if send then begin
      if device_spec.send_page eq 1 then begin
          if device_spec.device_type eq 'printer' then begin
              if device_spec.onefile eq 0 then begin
                  device, /close
              endif else begin
                  pold= !p
                  plot, [1,2], /nodata, xstyle=4, ystyle=4
                  !p= pold
              endelse
              if not device_spec.print2file then begin
                  printstr= 'lp -cd'+device_spec.printer_name+' '
                  spawn, printstr+device_spec.filename
                  spawn, 'rm '+device_spec.filename
              endif
              spawn, "echo $$", uniqueid 
              uniqueid=strtrim(uniqueid(0),2)
              if n_elements( explicit_filename_in ) eq 0 then begin
                  explicit_filename= device_spec.filename_pre+uniqueid+'.'+ $
                    device_spec.name
              endif else begin
                  explicit_filename= explicit_filename_in
              endelse
              device, filename=explicit_filename
              device_spec.filename=explicit_filename
          endif else begin
;              erase
          endelse
;          pdef.draw_title=1
          titlepos= ( position(3)-position(1) ) * 1.03 + position(1)
          xyouts, position(0), titlepos, title, /normal, charsize=1.1
;          pdef.draw_title=0

          device_spec.send_page=0              
      endif      
  endif else if next then begin
      if pdef.next_plot_number eq 0 and $
        device_spec.autoclear then begin
          if device_spec.send_page eq 1 then begin
              if device_spec.device_type eq 'printer' then begin
                  device, /close
                  if not device_spec.print2file then begin
                      printstr= 'lp -cd'+device_spec.printer_name+' '
                      spawn, printstr+device_spec.filename
                      spawn, 'rm '+device_spec.filename
                  endif
                  spawn, "echo $$", uniqueid 
                  uniqueid=strtrim(uniqueid(0),2)
                  device, filename=device_spec.filename_pre+uniqueid+'.'+ $
                    device_spec.name
                  device_spec.filename=device_spec.filename_pre+uniqueid+'.'+$
                    device_spec.name
              endif else begin
                  erase
              endelse
              pdef.draw_title=1
              titlepos= ( position(3)-position(1) ) * 1.03 + position(1)
              xyouts, position(0), titlepos, title, /normal, charsize=1.1
              pdef.draw_title=0        
          endif
      endif

      plotParm_out= pdef.plotParms
                  
      device_spec.send_page=1    
      this_h= pdef.next_plot_number mod pdef.horizontal_panels
      this_v= pdef.vertical_panels - 1 - $
        pdef.next_plot_number / pdef.horizontal_panels

      ll= [ pdef.xorigin + pdef.xdeltaplot * this_h, $
            pdef.yorigin + pdef.ydeltaplot * this_v ]
      ur= [ ll(0)+pdef.plotwidth, ll(1)+pdef.plotheight ]
      
      plotParm_out.position=[ll,ur]

      blankticks= replicate(' ',30)
      nullticks= replicate('',30)
      if pdef.hidelabel then begin
          case ((this_h) eq 0)*1 + ((this_v) eq 0)*2 of    
              0: begin          ; interior
                  plotParm_out.xtitle=' '                  
                  plotParm_out.xtickname=blankticks
                  plotParm_out.ytitle=' '              
                  plotParm_out.ytickname=blankticks
                  plotParm_out.xtickformat=''
                  plotParm_out.ytickformat=''
              end
              1: begin          ; leftside
                  plotParm_out.xtitle=' '
                  plotParm_out.xtickname=blankticks
                  plotParm_out.ytickname=nullticks
                  plotParm_out.xtickformat=''
              end
              2: begin          ; bottom
                  plotParm_out.xtickname=nullticks
                  plotParm_out.ytitle=' '
                  plotParm_out.ytickname=blankticks              
                  plotParm_out.ytickformat=''
              end
              3: begin          ; bottom-left corner
                  plotParm_out.xtickname=nullticks              
                  plotParm_out.ytickname=nullticks              
              end
          endcase
      endif else begin          ; don't hide axis labels
          plotParm_out.xtickname=nullticks              
          plotParm_out.ytickname=nullticks              
      endelse 

      pdef.next_plot_number= pdef.next_plot_number+1
      if pdef.next_plot_number eq pdef.number_of_plots then begin
          pdef.next_plot_number=0
      endif

  endif else if (overplot) then begin
      !x=pdef.x
      !y=pdef.y
      if n_params() eq 2 then begin
          arg2=arg1
          arg1=lindgen(n_elements(arg2))
      endif
      oplot, arg1, arg2, _extra=PlotParm

  endif else if (plot) then begin
      if keyword_set(charsize) then begin
          charsize= min([pdef.plotwidth,pdef.plotheight])*charsize*5
      endif else begin
          charsize= min([pdef.plotwidth,pdef.plotheight])*5 < 2.0
      endelse
      
      if n_params() eq 2 then begin
          arg2=arg1
          arg1=lindgen(n_elements(arg2))
      endif

      if pdef.next_plot_number eq 0 and $
        device_spec.autoclear then begin
          if device_spec.send_page eq 1 then begin
              if device_spec.device_type eq 'printer' then begin
                  device, /close
                  if not device_spec.print2file then begin
                      printstr= 'lp -cd'+device_spec.printer_name+' '
                      spawn, printstr+device_spec.filename
                      spawn, 'rm '+device_spec.filename
                  endif
                  spawn, "echo $$", uniqueid 
                  uniqueid=strtrim(uniqueid(0),2)
                  device, filename=device_spec.filename_pre+uniqueid+'.'+ $
                    device_spec.name
                  device_spec.filename=device_spec.filename_pre+uniqueid+'.'+$
                    device_spec.name
              endif else begin
                  erase
              endelse
              pdef.draw_title=1
          endif
      endif

      device_spec.send_page=1
      
      if pdef.draw_title eq 1 then begin
          titlepos= ( position(3)-position(1) ) * 1.03 + position(1)
          xyouts, position(0), titlepos, title, /normal, charsize=1.0
          pdef.draw_title=0
      endif

      this_h= pdef.next_plot_number mod pdef.horizontal_panels
      this_v= pdef.vertical_panels - 1 - $
        pdef.next_plot_number / pdef.horizontal_panels

      ll= [ pdef.xorigin + pdef.xdeltaplot * this_h, $
            pdef.yorigin + pdef.ydeltaplot * this_v ]
      ur= [ ll(0)+pdef.plotwidth, ll(1)+pdef.plotheight ]
      
      blankticks= replicate(' ',30)
      if pdef.hidelabel then begin
          if anti_alias eq 0 then begin
              case ((this_h) eq 0)*1 + ((this_v) eq 0)*2 of    
                  0: $              ; interior
                    plot, arg1, arg2, _extra=plotParm, $
                    xtickname=blankticks, ytickname=blankticks, $            
                    title=title, charsize=charsize, $
                    position= [ ll, ur ], /noerase
                  1: $              ; leftside
                    plot, arg1, arg2, _extra=plotParm, $
                    xtickname=blankticks, $
                    ytitle=ytitle, charsize=charsize, $
                    title=title, $
                    position= [ ll, ur ], /noerase
                  2: $              ; bottom
                    plot, arg1, arg2, _extra=plotParm, $
                    ytickname=blankticks, $
                    xtitle=xtitle, charsize=charsize, $
                    title=title, $
                    position= [ ll, ur ], /noerase
                  3: $              ; bottom-left corner
                    plot, arg1, arg2, _extra=plotParm, $
                    xtitle=xtitle, $
                    ytitle=ytitle, $
                    title=title, charsize=charsize, $
                    position= [ ll, ur ], /noerase
              endcase
          endif else begin
             case ((this_h) eq 0)*1 + ((this_v) eq 0)*2 of    
                  0: $              ; interior
                    plot_anti_alias, arg1, arg2, _extra=plotParm, $
                    xtickname=blankticks, ytickname=blankticks, $            
                    title=title, charsize=charsize, $
                    position= [ ll, ur ], /noerase
                  1: $              ; leftside
                    plot_anti_alias, arg1, arg2, _extra=plotParm, $
                    xtickname=blankticks, $
                    ytitle=ytitle, charsize=charsize, $
                    title=title, $
                    position= [ ll, ur ], /noerase
                  2: $              ; bottom
                    plot_anti_alias, arg1, arg2, _extra=plotParm, $
                    ytickname=blankticks, $
                    xtitle=xtitle, charsize=charsize, $
                    title=title, $
                    position= [ ll, ur ], /noerase
                  3: $              ; bottom-left corner
                    plot_anti_alias, arg1, arg2, _extra=plotParm, $
                    xtitle=xtitle, $
                    ytitle=ytitle, $
                    title=title, charsize=charsize, $
                    position= [ ll, ur ], /noerase
              endcase
          endelse
      endif else begin
          if anti_alias then begin
              plot_anti_alias, arg1, arg2, _extra=plotParm, $
                xtitle=xtitle, $
                ytitle=ytitle, $
                title=title, charsize=charsize, $
                position= [ ll, ur ], /noerase
          endif else begin
              plot, arg1, arg2, _extra=plotParm, $
                xtitle=xtitle, $
                ytitle=ytitle, $
                title=title, charsize=charsize, $
                position= [ ll, ur ], /noerase
          endelse
      endelse

      pdef.x= !x
      pdef.y= !y
      
      pdef.next_plot_number= pdef.next_plot_number+1
      if pdef.next_plot_number eq pdef.number_of_plots then begin
          pdef.next_plot_number=0
      endif
  endif
  return
end
      

